/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import com.github._1c_syntax.bsl.languageserver.diagnostics.BSLDiagnostic;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagnosticHelper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticHelper.class);

    public static boolean equalNodes(Tree leftNode, Tree rightNode) {
        int rightNodeType;
        int leftNodeType;
        if (leftNode.getChildCount() != rightNode.getChildCount() || !leftNode.getClass().equals(rightNode.getClass())) {
            return false;
        }
        if (leftNode instanceof TerminalNode && ((leftNodeType = ((TerminalNode)leftNode).getSymbol().getType()) != (rightNodeType = ((TerminalNode)rightNode).getSymbol().getType()) || leftNodeType == 37 && !leftNode.toString().equals(rightNode.toString()) || !leftNode.toString().equalsIgnoreCase(rightNode.toString()))) {
            return false;
        }
        for (int i = 0; i < leftNode.getChildCount(); ++i) {
            if (DiagnosticHelper.equalNodes(leftNode.getChild(i), rightNode.getChild(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isStructureType(ParseTree tnc) {
        return "\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430".equalsIgnoreCase(tnc.getText()) || "Structure".equalsIgnoreCase(tnc.getText());
    }

    public static boolean isFixedStructureType(ParseTree tnc) {
        return "\u0424\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430".equalsIgnoreCase(tnc.getText()) || "FixedStructure".equalsIgnoreCase(tnc.getText());
    }

    public static boolean isWSDefinitionsType(ParseTree tnc) {
        return "WS\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f".equalsIgnoreCase(tnc.getText()) || "WSDefinitions".equalsIgnoreCase(tnc.getText());
    }

    public static boolean isFTPConnectionType(ParseTree tnc) {
        return "FTP\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435".equalsIgnoreCase(tnc.getText()) || "FTPConnection".equalsIgnoreCase(tnc.getText());
    }

    public static boolean isInternetMailProfileType(ParseTree tnc) {
        return "\u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u041f\u043e\u0447\u0442\u043e\u0432\u044b\u0439\u041f\u0440\u043e\u0444\u0438\u043b\u044c".equalsIgnoreCase(tnc.getText()) || "InternetMailProfile".equalsIgnoreCase(tnc.getText());
    }

    public static void configureDiagnostic(BSLDiagnostic diagnostic, Map<String, Object> configuration) {
        if (configuration == null || configuration.isEmpty()) {
            return;
        }
        HashSet<Class> types = new HashSet<Class>();
        types.add(Integer.class);
        types.add(Boolean.class);
        types.add(Float.class);
        types.add(String.class);
        diagnostic.getInfo().getParameters().stream().filter(diagnosticParameterInfo -> configuration.containsKey(diagnosticParameterInfo.getName()) && types.contains(diagnosticParameterInfo.getType())).forEach(diagnosticParameterInfo -> {
            try {
                Field field = diagnostic.getClass().getDeclaredField(diagnosticParameterInfo.getName());
                if (field.trySetAccessible()) {
                    field.set(diagnostic, configuration.get(field.getName()));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOGGER.error("Can't set param.", (Throwable)e);
            }
        });
    }

    public static void configureDiagnostic(BSLDiagnostic diagnostic, Map<String, Object> configuration, String ... filter) {
        HashMap<String, Object> newConfiguration = new HashMap<String, Object>();
        for (String name : filter) {
            if (!configuration.containsKey(name)) continue;
            newConfiguration.put(name, configuration.get(name));
        }
        DiagnosticHelper.configureDiagnostic(diagnostic, newConfiguration);
    }

    public static Pattern createPatternFromString(String words) {
        return DiagnosticHelper.createPatternFromString(words, ",");
    }

    public static Pattern createPatternFromString(String words, String delimiter) {
        StringJoiner stringJoiner = new StringJoiner("|");
        for (String elem : words.split(delimiter)) {
            stringJoiner.add(Pattern.quote(elem.trim()));
        }
        return CaseInsensitivePattern.compile((String)("(?:^" + String.valueOf(stringJoiner) + ").*"));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private DiagnosticHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

