# Missed a required method parameter (MissedRequiredParameter)

|  Type   |        Scope        | Severity |    Activated<br>by default    |    Minutes<br>to fix    |  Tags   |
|:-------:|:-------------------:|:--------:|:-----------------------------:|:-----------------------:|:-------:|
| `Error` |    `BSL`<br>`OS`    | `Major`  |             `Yes`             |           `1`           | `error` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Description

Required parameters must not be omitted when calling methods, otherwise the value `Undefined` will be passed to the parameter, which the method often cannot process.
If the value `Undefined` is valid, then you need to
- explicitly pass a value
- or make the parameter optional with a default value of `Undefined`.
## Examples

For example

```bsl
Procedure ChangeFormFieldColor(Form, FiledName, Color)
```

Incorrect:

```bsl
ChangeFormFieldColor(,"Result", StyleColors.ArthursShirtColor); // missing first parameter Form
ChangeFormFieldColor(,,); // missing all required parameters
```

Correct:

```bsl
ChangeFormFieldColor(ThisObject, "Result", Color); // all required parameters are specified
```

## Sources

[Parameters of procedures and functions (RU)](https://its.1c.ru/db/v8std#content:640:hdoc)

## Snippets

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Diagnostic ignorance in code

```bsl
// BSLLS:MissedRequiredParameter-off
// BSLLS:MissedRequiredParameter-on
```

### Parameter for config

```json
"MissedRequiredParameter": false
```
