# Referencing a missing common module method (MissingCommonModuleMethod)

|  Type   | Scope | Severity  |    Activated<br>by default    |    Minutes<br>to fix    |  Tags   |
|:-------:|:-----:|:---------:|:-----------------------------:|:-----------------------:|:-------:|
| `Error` | `BSL` | `Blocker` |             `Yes`             |           `5`           | `error` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Description
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Diagnostics detects erroneous calls to methods of common modules.
Detects the following errors
- method does not exist in the specified common module
- method is in the common module, but it is not exported
- if a common module has no source code, then all calls to its methods are marked as erroneous

Excluded
- the variable name is the same as the common module name
## Examples
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Sources
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Snippets

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Diagnostic ignorance in code

```bsl
// BSLLS:MissingCommonModuleMethod-off
// BSLLS:MissingCommonModuleMethod-on
```

### Parameter for config

```json
"MissingCommonModuleMethod": false
```
