# Общий модуль недопустимого типа (CommonModuleInvalidType)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                         Теги                          |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-----------------------------------------------------:|
| `Ошибка` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |       `standard`<br>`unpredictable`<br>`design`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

При разработке общих модулей следует выбирать один из четырех контекстов выполнения кода:

|Тип общего модуля | Пример наименования | Вызов сервера | Сервер | Внешнее соединение | Клиент(обычное приложение) | Клиент(управляемое приложение)|
| -- | -- | -- | -- | -- | -- | -- |
| Серверный | ОбщегоНазначения (или ОбщегоНазначенияСервер) |   | + | + | + |  
| Серверный для вызова с клиента | ОбщегоНазначенияВызовСервера | + | + |   |   |  
| Клиентский | ОбщегоНазначенияКлиент (или ОбщегоНазначенияГлобальный) |   |   |   | + | +
| Клиент-серверный | ОбщегоНазначенияКлиентСервер |   | + | + | + | +|


## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники

* Источник: [Стандарт: Правила создания общих модулей](https://its.1c.ru/db/v8std#content:469:hdoc:1.2)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CommonModuleInvalidType-off
// BSLLS:CommonModuleInvalidType-on
```

### Параметр конфигурационного файла

```json
"CommonModuleInvalidType": false
```
