# Общий модуль должен иметь программный интерфейс (CommonModuleMissingAPI)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                 Теги                  |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:-------------------------------------:|
| `Дефект кода` |             `BSL`             | `Незначительный` |              `Да`              |                 `1`                 |    `brainoverload`<br>`suspicious`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Общий модуль должен иметь хотя бы один экспортный метод, а также область "ПрограммныйИнтерфейс" или "СлужебныйПрограммныйИнтерфейс". 

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильно

```Bsl
// начало модуля
Процедура Тест(А)
    А = А + 1;
КонецПроцедуры
// конец модуля
```

Правильно

```Bsl
// начало модуля
#Область СлужебныйПрограммныйИнтерфейс
Процедура Тест(А) Экспорт
    А = А + 1;
КонецПроцедуры
#КонецОбласти
// конец модуля
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

Источник: [Стандарт: Структура модулей](https://its.1c.ru/db/v8std#content:455:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CommonModuleMissingAPI-off
// BSLLS:CommonModuleMissingAPI-on
```

### Параметр конфигурационного файла

```json
"CommonModuleMissingAPI": false
```
