# Пропущен постфикс "ПовтИсп" (CommonModuleNameCached)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                            Теги                            |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:----------------------------------------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |       `standard`<br>`badpractice`<br>`unpredictable`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Модули, предназначенные для реализации на сервере или на клиенте функций с повторным использованием возвращаемых 
значений (на время вызова или на время сеанса), именуются с постфиксом "ПовтИсп" (англ. "Cached") 
и "КлиентПовтИсп" (англ. "ClientCached") соответственно.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

РаботаСФайламиКлиентПовтИсп, UsersInternalCached

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->


[Стандарт: Правила создания общих модулей](https://its.1c.ru/db/v8std#content:469:hdoc:3.2.3)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CommonModuleNameCached-off
// BSLLS:CommonModuleNameCached-on
```

### Параметр конфигурационного файла

```json
"CommonModuleNameCached": false
```
