# Отсутствует проверка признака ОбменДанными.Загрузка в обработчике событий объекта (DataExchangeLoading)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                            Теги                            |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:----------------------------------------------------------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                 `5`                 |       `standard`<br>`badpractice`<br>`unpredictable`       |

## Параметры


|     Имя     |   Тип    |           Описание            |    Значение<br>по умолчанию    |
|:-----------:|:--------:|:-----------------------------:|:------------------------------:|
| `findFirst` | `Булево` | `Проверка должна идти первой` |            `false`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Все действия в процедурах-обработчиков событий ПередЗаписью, ПриЗаписи, ПередУдалением должны выполняться 
после проверки на ОбменДанными.Загрузка.

Это необходимо для того, чтобы никакая бизнес-логика объекта не выполнялась при записи объекта через механизм обмена 
данными, поскольку она уже была выполнена для объекта в том узле, где он был создан. В этом случае все данные 
загружаются в ИБ "как есть", без искажений (изменений), проверок или каких-либо других дополнительных действий, 
препятствующих загрузке данных.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильно:
```bsl
Процедура ПередЗаписью(Отказ)

    Если Не Отказ Тогда
        ЗапутитьКакойТоАлгоритм();
    КонецЕсли;

    // код обработчика
    //
    // ...
    
КонецПроцедуры
```
Правильно:
```bsl
Процедура ПередЗаписью(Отказ)
    Если ОбменДанными.Загрузка Тогда
         Возврат;
    КонецЕсли;

    // код обработчика
    // ...
КонецПроцедуры
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

* [Стандарт: Использование признака ОбменДанными.Загрузка в обработчиках событий объекта](https://its.1c.ru/db/v8std#content:773)
* [Обработчик события ПриЗаписи](https://its.1c.ru/db/v8std#content:465)
* [Обработчик события ПередЗаписью](https://its.1c.ru/db/v8std#content:464)
* [Обработчик события ПередУдалением](https://its.1c.ru/db/v8std#content:752)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:DataExchangeLoading-off
// BSLLS:DataExchangeLoading-on
```

### Параметр конфигурационного файла

```json
"DataExchangeLoading": {
    "findFirst": false
}
```
