# Удаление элемента при обходе коллекции посредством оператора "Для каждого ... Из ... Цикл" (DeletingCollectionItem)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |            Теги             |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 |    `standard`<br>`error`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Не следует непосредственно удалять элементы коллекции при ее обходе через синтаксическую конструкцию
**Для каждого ... Из ... Цикл**. Т.к. при удалении элемента сдвигается индекс следующего элемента.

Например:

```bsl
Для Каждого Элемент Из Коллекция Цикл
   Коллекция.Удалить(Элемент)
КонецЦикла;
```

Как вариант удаляйте элементы с конца:

```bsl
ТекущийИндекс = Числа.ВГраница();
Пока ТекущийИндекс >= 0 Цикл
    Если Числа[ТекущийИндекс] < 10 Тогда
        Числа.Удалить(ТекущийИндекс);
    КонецЕсли;
    ТекущийИндекс = ТекущийИндекс – 1;
КонецЦикла;
```

## Источники

* [1С:Программирование для начинающих. Разработка в системе "1С:Предприятие 8.3"](https://its.1c.ru/db/pubprogforbeginners#content:88:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:DeletingCollectionItem-off
// BSLLS:DeletingCollectionItem-on
```

### Параметр конфигурационного файла

```json
"DeletingCollectionItem": false
```
