# Использование устаревшего метода "ТекущаяДата" (DeprecatedCurrentDate)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                           Теги                            |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------------------------------------:|
| `Ошибка` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |       `standard`<br>`deprecated`<br>`unpredictable`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Конфигурации должны быть рассчитаны на работу в условиях, когда часовой пояс на серверном компьютере не совпадает с реальным часовым поясом пользователей информационной базы. Например, с сервером, расположенным в Москве, работают сотрудники компании из Владивостока, и при этом все операции в системе должны выполняться по местному времени (Владивостока).

Такой сценарий работы часто востребован в клиент-серверных информационных базах и в прикладных решениях в модели сервиса (SaaS).

Во всех серверных процедурах и функциях вместо функции ТекущаяДата, которая возвращает дату и время серверного компьютера, следует использовать функцию ТекущаяДатаСеанса, которая приводит время сервера к часовому поясу пользовательского сеанса.

В клиентском коде использование функции ТекущаяДата также недопустимо. Это требование обусловлено тем, что текущее время, вычисленное в клиентском и серверном коде, не должно различаться.

При использовании Библиотеки стандартных подсистем рекомендуется использовать функцию ДатаСеанса общего модуля ОбщегоНазначенияКлиент.

## Примеры

### На клиенте
Неправильно:

```bsl
ДатаОперации = ТекущаяДата();
```

Правильно:

```bsl
ДатаОперации = ОбщегоНазначенияКлиент.ДатаСеанса();
```

### На сервере

```bsl
ДатаОперации = ТекущаяДата();
```

Правильно:

```bsl
ДатаОперации = ТекущаяДатаСеанса();
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->


* Источник: [Создание и изменение объектов метаданных. Работа в разных часовых поясах](https://its.1c.ru/db/v8std/content/643/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:DeprecatedCurrentDate-off
// BSLLS:DeprecatedCurrentDate-on
```

### Параметр конфигурационного файла

```json
"DeprecatedCurrentDate": false
```
