# Устаревшие методы не должны использоваться (DeprecatedMethodCall)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |              Теги              |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                 `3`                 |    `deprecated`<br>`design`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

В случаях когда возникает необходимость отметить процедуру (функцию) как устаревшую, в первой строке ее описания размещается слово "Устарела." (англ. "Deprecated.").

Следует избегать использования или расширения устаревших методов. Пометка метода как устаревшего - это предупреждение о том, что метод будет удален в будущих версиях и оставлен для временной обратной совместимости.

Исключение: допустимо вызывать устаревшие методы из устаревших методов.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

```bsl
// Устарела. Следует использовать НеУстаревшаяПроцедура.
Процедура УстаревшаяПроцедура()
КонецПроцедуры

УстаревшаяПроцедура(); // Срабатывание диагностики
```

## Источники

* Источник: [Стандарт: Описание процедур и функций](https://its.1c.ru/db/v8std/content/453/hdoc), раздел 5.7
* [CWE-477 Use of Obsolete Function](http://cwe.mitre.org/data/definitions/477.html)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:DeprecatedMethodCall-off
// BSLLS:DeprecatedMethodCall-on
```

### Параметр конфигурационного файла

```json
"DeprecatedMethodCall": false
```
