# Запуск внешних приложений (ExternalAppStarting)

|     Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Уязвимость` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 | `suspicious` |

## Параметры


|         Имя         |   Тип    |                     Описание                     |                                                                                             Значение<br>по умолчанию                                                                                              |
|:-------------------:|:--------:|:------------------------------------------------:|:-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
|   `checkGotoUrl`    | `Булево` |   `Проверять переход по навигационным ссылкам`   |                                                                                                      `false`                                                                                                      |
| `userPatternString` | `Строка` | `Пользовательский шаблон (регулярное выражение)` | `КомандаСистемы|System|ЗапуститьСистему|RunSystem|ЗапуститьПриложение|RunApp|НачатьЗапускПриложения|BeginRunningApplication|ЗапуститьПриложениеАсинх|RunAppAsync|ЗапуститьПрограмму|ОткрытьПроводник|ОткрытьФайл` |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Для повышения качества и безопасности решения на 1С необходимо контролировать запуск внешних приложений из кода 1С.

Данное правило распространяется на все способы запуска внешних программ, в том числе:
- КомандаСистемы
- ЗапуститьСистему
- ЗапуститьПриложение
- НачатьЗапускПриложения
- ЗапуститьПриложениеАсинх
- ПерейтиПоНавигационнойСсылке или ФайловаяСистемаКлиент.ОткрытьНавигационнуюСсылку
- ФайловаяСистемаКлиент.ЗапуститьПрограмму (в клиентском коде) и ФайловаяСистема.ЗапуститьПрограмму (в серверном коде)
- ФайловаяСистемаКлиент.ОткрытьПроводник
- ФайловаяСистемаКлиент.ОткрытьФайл

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
```bsl
Процедура Метод()
    СтрокаКоманды = "";
    ТекущийКаталог = "";
    ДождатьсяЗавершения = Истина;
    ОписаниеОповещения = Неопределено;
    ПараметрыКоманды = Новый Структура;

    КомандаСистемы(СтрокаКоманды, ТекущийКаталог); // есть замечание
    ЗапуститьПриложение(СтрокаКоманды, ТекущийКаталог); // есть замечание
    ЗапуститьПриложение(СтрокаКоманды, ТекущийКаталог, Истина); // есть замечание

    НачатьЗапускПриложения(ОписаниеОповещения, СтрокаКоманды, ТекущийКаталог, ДождатьсяЗавершения); // есть замечание

    ПерейтиПоНавигационнойСсылке(СтрокаКоманды); // есть замечание
    ФайловаяСистемаКлиент.ОткрытьНавигационнуюСсылку(СтрокаКоманды); // есть замечание
    ФайловаяСистемаКлиент.ОткрытьНавигационнуюСсылку(СтрокаКоманды, ОписаниеОповещения); // есть замечание

    ФайловаяСистемаКлиент.ЗапуститьПрограмму("ping 127.0.0.1 -n 5", ПараметрыКоманды); // есть замечание
    ФайловаяСистемаКлиент.ЗапуститьПрограмму(СтрокаКоманды, ПараметрыКоманды); // есть замечание
    ФайловаяСистема.ЗапуститьПрограмму(СтрокаКоманды); // есть замечание
    ФайловаяСистема.ЗапуститьПрограмму(СтрокаКоманды, ПараметрыКоманды); // есть замечание

    ФайловаяСистемаКлиент.ОткрытьПроводник("C:\Users"); // есть замечание
    ФайловаяСистемаКлиент.ОткрытьФайл(СтрокаКоманды); // есть замечание
    ФайловаяСистемаКлиент.ОткрытьФайл(СтрокаКоманды, ОписаниеОповещения); // есть замечание

КонецПроцедуры

&НаКлиенте
Асинх Процедура Подключить()
    СтрокаКоманды = "";
    ТекущийКаталог = "";
    ДождатьсяЗавершения = Истина;

    Ждать ЗапуститьПриложениеАсинх(СтрокаКоманды, ТекущийКаталог, ДождатьсяЗавершения); // есть замечание
КонецПроцедуры

&НаКлиенте
Процедура ПроверкаЗапуститьСистему(ДополнительныеПараметрыКоманднойСтроки, КодВозврата)
    ДождатьсяЗавершения = Истина;

    ЗапуститьСистему(); // есть замечание
    ЗапуститьСистему(ДополнительныеПараметрыКоманднойСтроки); // есть замечание
    ЗапуститьСистему(ДополнительныеПараметрыКоманднойСтроки, ДождатьсяЗавершения); // есть замечание
    ЗапуститьСистему(ДополнительныеПараметрыКоманднойСтроки, ДождатьсяЗавершения, КодВозврата); // есть замечание
КонецПроцедуры
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
- [стандарт Безопасность запуска приложений](https://its.1c.ru/db/v8std/content/774/hdoc)
- [стандарт Ограничение на выполнение «внешнего» кода](https://its.1c.ru/db/v8std/content/669/hdoc )

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:ExternalAppStarting-off
// BSLLS:ExternalAppStarting-on
```

### Параметр конфигурационного файла

```json
"ExternalAppStarting": {
    "checkGotoUrl": false,
    "userPatternString": "КомандаСистемы|System|ЗапуститьСистему|RunSystem|ЗапуститьПриложение|RunApp|НачатьЗапускПриложения|BeginRunningApplication|ЗапуститьПриложениеАсинх|RunAppAsync|ЗапуститьПрограмму|ОткрытьПроводник|ОткрытьФайл"
}
```
