# Доступ к файловой системе (FileSystemAccess)

|     Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Уязвимость` |             `BSL`             | `Важный` |             `Нет`              |                 `3`                 | `suspicious` |

## Параметры


|       Имя       |   Тип    |                      Описание                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Значение<br>по умолчанию                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
|:---------------:|:--------:|:--------------------------------------------------:|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| `globalMethods` | `Строка` | `Шаблон глобальных методов (регулярное выражение)` | `ЗначениеВФайл|ValueToFile|КопироватьФайл|FileCopy|ОбъединитьФайлы|MergeFiles|ПереместитьФайл|MoveFile|РазделитьФайл|SplitFile|СоздатьКаталог|CreateDirectory|УдалитьФайлы|DeleteFiles|КаталогПрограммы|BinDir|КаталогВременныхФайлов|TempFilesDir|КаталогДокументов|DocumentsDir|РабочийКаталогДанныхПользователя|UserDataWorkDir|НачатьПодключениеРасширенияРаботыСФайлами|BeginAttachingFileSystemExtension|НачатьУстановкуРасширенияРаботыСФайлами|BeginInstallFileSystemExtension|УстановитьРасширениеРаботыСФайлами|InstallFileSystemExtension|УстановитьРасширениеРаботыСФайламиАсинх|InstallFileSystemExtensionAsync|ПодключитьРасширениеРаботыСФайламиАсинх|AttachFileSystemExtensionAsync|КаталогВременныхФайловАсинх|TempFilesDirAsync|КаталогДокументовАсинх|DocumentsDirAsync|НачатьПолучениеКаталогаВременныхФайлов|BeginGettingTempFilesDir|НачатьПолучениеКаталогаДокументов|BeginGettingDocumentsDir|НачатьПолучениеРабочегоКаталогаДанныхПользователя|BeginGettingUserDataWorkDir|РабочийКаталогДанныхПользователяАсинх|UserDataWorkDirAsync|КопироватьФайлАсинх|CopyFileAsync|НайтиФайлыАсинх|FindFilesAsync|НачатьКопированиеФайла|BeginCopyingFile|НачатьПеремещениеФайла|BeginMovingFile|НачатьПоискФайлов|BeginFindingFiles|НачатьСозданиеДвоичныхДанныхИзФайла|BeginCreateBinaryDataFromFile|НачатьСозданиеКаталога|BeginCreatingDirectory|НачатьУдалениеФайлов|BeginDeletingFiles|ПереместитьФайлАсинх|MoveFileAsync|СоздатьДвоичныеДанныеИзФайлаАсинх|CreateBinaryDataFromFileAsync|СоздатьКаталогАсинх|CreateDirectoryAsync|УдалитьФайлыАсинх|DeleteFilesAsync` |
| `newExpression` | `Строка` |      `Шаблон классов (регулярное выражение)`       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                `File|Файл|xBase|HTMLWriter|ЗаписьHTML|HTMLReader|ЧтениеHTML|FastInfosetReader|ЧтениеFastInfoset|FastInfosetWriter|ЗаписьFastInfoset|XSLTransform|ПреобразованиеXSL|ZipFileWriter|ЗаписьZipФайла|ZipFileReader|ЧтениеZipФайла|TextReader|ЧтениеТекста|TextWriter|ЗаписьТекста|TextExtraction|ИзвлечениеТекста|BinaryData|ДвоичныеДанные|FileStream|ФайловыйПоток|FileStreamsManager|МенеджерФайловыхПотоков|DataWriter|ЗаписьДанных|DataReader|ЧтениеДанных`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При код-ревью или аудите кода необходимо проверять обращения к файлам, каталогам и набор действий, выполняемых с ними, для исключения передачи конфиденциальной или защищенной информации, а также для исключения деструктивных действий с файловой системой.
Важно проверять код от сторонних разработчиков, подрядчиков, из различных интернет-сервисов, каталогов и т.п.

По найденным замечаниям рекомендуется выполнить ручной аудит кода на предмет его правильности и безопасности.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
```bsl
    Текст = Новый ЧтениеТекста(ПутьФайла, КодировкаТекста.ANSI); // есть замечание
    Текст = Новый ЗаписьТекста(ПутьФайла, КодировкаТекста.ANSI); // есть замечание

    ЗначениеВФайл(ПутьФайла, ЛичныеДанные); // есть замечание
    КопироватьФайл(ПутьФайла, ДругойПутьФайла); // есть замечание

    МассивИмен = Новый Массив();
    МассивИмен.Добавить(ПутьФайла);
    ОбъединитьФайлы(МассивИмен, ДругойПутьФайла); // есть замечание

    ПереместитьФайл(ПутьФайла, ДругойПутьФайла); // есть замечание
    РазделитьФайл(ПутьФайла, 1024 * 1024 ); // есть замечание
    СоздатьКаталог(ИмяКаталога); // есть замечание
    УдалитьФайлы(ПутьФайла); // есть замечание
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
* [Стандарт Доступ к файловой системе из кода конфигурации](https://its.1c.ru/db/v8std#content:542:hdoc)
* [Стандарт Безопасность запуска приложений](https://its.1c.ru/db/v8std#content:774:hdoc)
* [Безопасный режим работы - руководство разработчика](https://its.1c.ru/db/v8323doc#bookmark:dev:TI000000186)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:FileSystemAccess-off
// BSLLS:FileSystemAccess-on
```

### Параметр конфигурационного файла

```json
"FileSystemAccess": {
    "globalMethods": "ЗначениеВФайл|ValueToFile|КопироватьФайл|FileCopy|ОбъединитьФайлы|MergeFiles|ПереместитьФайл|MoveFile|РазделитьФайл|SplitFile|СоздатьКаталог|CreateDirectory|УдалитьФайлы|DeleteFiles|КаталогПрограммы|BinDir|КаталогВременныхФайлов|TempFilesDir|КаталогДокументов|DocumentsDir|РабочийКаталогДанныхПользователя|UserDataWorkDir|НачатьПодключениеРасширенияРаботыСФайлами|BeginAttachingFileSystemExtension|НачатьУстановкуРасширенияРаботыСФайлами|BeginInstallFileSystemExtension|УстановитьРасширениеРаботыСФайлами|InstallFileSystemExtension|УстановитьРасширениеРаботыСФайламиАсинх|InstallFileSystemExtensionAsync|ПодключитьРасширениеРаботыСФайламиАсинх|AttachFileSystemExtensionAsync|КаталогВременныхФайловАсинх|TempFilesDirAsync|КаталогДокументовАсинх|DocumentsDirAsync|НачатьПолучениеКаталогаВременныхФайлов|BeginGettingTempFilesDir|НачатьПолучениеКаталогаДокументов|BeginGettingDocumentsDir|НачатьПолучениеРабочегоКаталогаДанныхПользователя|BeginGettingUserDataWorkDir|РабочийКаталогДанныхПользователяАсинх|UserDataWorkDirAsync|КопироватьФайлАсинх|CopyFileAsync|НайтиФайлыАсинх|FindFilesAsync|НачатьКопированиеФайла|BeginCopyingFile|НачатьПеремещениеФайла|BeginMovingFile|НачатьПоискФайлов|BeginFindingFiles|НачатьСозданиеДвоичныхДанныхИзФайла|BeginCreateBinaryDataFromFile|НачатьСозданиеКаталога|BeginCreatingDirectory|НачатьУдалениеФайлов|BeginDeletingFiles|ПереместитьФайлАсинх|MoveFileAsync|СоздатьДвоичныеДанныеИзФайлаАсинх|CreateBinaryDataFromFileAsync|СоздатьКаталогАсинх|CreateDirectoryAsync|УдалитьФайлыАсинх|DeleteFilesAsync",
    "newExpression": "File|Файл|xBase|HTMLWriter|ЗаписьHTML|HTMLReader|ЧтениеHTML|FastInfosetReader|ЧтениеFastInfoset|FastInfosetWriter|ЗаписьFastInfoset|XSLTransform|ПреобразованиеXSL|ZipFileWriter|ЗаписьZipФайла|ZipFileReader|ЧтениеZipФайла|TextReader|ЧтениеТекста|TextWriter|ЗаписьТекста|TextExtraction|ИзвлечениеТекста|BinaryData|ДвоичныеДанные|FileStream|ФайловыйПоток|FileStreamsManager|МенеджерФайловыхПотоков|DataWriter|ЗаписьДанных|DataReader|ЧтениеДанных"
}
```
