# Отсутствует описание параметров метода (MissingParameterDescription)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 |    `standard`<br>`badpractice`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Описание метода (процедуры или функции) должно оформляться корректно, помогая программистам правильно использовать функциональность.

Если метод содержит параметры, то в его описании, в одноименном блоке, должны быть приведены описания для всех параметров в том же порядке, что и в сигнатуре метода.

Диагностика обнаруживает типовые ошибки:

- Отсутствие описания всех параметров
- Отсутствие описания части параметров, с указанием, для какого параметра описание не обнаружено
- Присутствие в описании параметров, отсутстсвующих в сигнатуре метода (которые могли остаться от рефакторинга)
- Некачественное описание параметра: когда имя параметра присутствует в описании метода, но не указаны тип параметра и описание типа

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* Источник: [Стандарт: Описание процедур и функций](https://its.1c.ru/db/v8std#content:453:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MissingParameterDescription-off
// BSLLS:MissingParameterDescription-on
```

### Параметр конфигурационного файла

```json
"MissingParameterDescription": false
```
