# Инициализация параметров методов и конструкторов вызовом вложенных методов (NestedFunctionInParameters)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                            Теги                            |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------------------------------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                 `2`                 |       `standard`<br>`brainoverload`<br>`badpractice`       |

## Параметры


|         Имя          |   Тип    |                                   Описание                                   |               Значение<br>по умолчанию               |
|:--------------------:|:--------:|:----------------------------------------------------------------------------:|:----------------------------------------------------:|
|   `allowOneliner`    | `Булево` |                      `Разрешить однострочные выражения`                      |                        `true`                        |
| `allowedMethodNames` | `Строка` | `Имена методов, которые разрешено использовать для инициализации параметров` | `НСтр,NStr,ПредопределенноеЗначение,PredefinedValue` |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Не рекомендуется при передаче параметров в одну функцию применять вложенные вызовы других функций.  
Аналогино, не рекомендуется при инициализации параметров конструктора применять вложенные вызовы других функций или другие параметризированные конструкторы.

В то же время, если код с вложенными вызовами получается компактным (не требует переноса выражений) и легко читаемым, то вложенные вызовы допустимы.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильно:

```bsl
СтруктураВложений.Вставить(
 ПрисоединенныйФайл.Наименование,
 Новый Картинка(ПолучитьИзВременногоХранилища(
  ПрисоединенныеФайлы.ПолучитьДанныеФайла(ПрисоединенныйФайл.Ссылка).СсылкаНаДвоичныеДанныеФайла)));
```

Правильно разбивать такие вызовы на отдельные операторы с помощью вспомогательных локальных переменных:

```bsl
АдресФайлаИзображения = ПрисоединенныеФайлы.ПолучитьДанныеФайла(ПрисоединенныйФайл.Ссылка).СсылкаНаДвоичныеДанныеФайла;
ДанныеИзображения = Новый Картинка(ПолучитьИзВременногоХранилища(АдресФайлаИзображения));
СтруктураВложений.Вставить(ПрисоединенныйФайл.Наименование, ДанныеИзображения);
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->


* [Параметры процедур и функций](https://its.1c.ru/db/v8std#content:640:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:NestedFunctionInParameters-off
// BSLLS:NestedFunctionInParameters-on
```

### Параметр конфигурационного файла

```json
"NestedFunctionInParameters": {
    "allowOneliner": true,
    "allowedMethodNames": "НСтр,NStr,ПредопределенноеЗначение,PredefinedValue"
}
```
