# Обращение к методам привилегированных модулей (PrivilegedModuleMethodCall)

|            Тип             |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:--------------------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Потенциальная уязвимость` |             `BSL`             | `Важный` |              `Да`              |                `60`                 | `suspicious` |

## Параметры


|          Имя          |   Тип    |                             Описание                              |    Значение<br>по умолчанию    |
|:---------------------:|:--------:|:-----------------------------------------------------------------:|:------------------------------:|
| `validateNestedCalls` | `Булево` | `Проверять вложенные вызовы методов из привилегированных модулей` |             `true`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При обращении к публичным процедурам и функциям привилегированных общих модулей могут нарушаться ограничения конфигурации по правам и ролям конфигурации, решения 1С.
Необходимо провалидировать подобные обращения для исключения обхода ограничений.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->
Например, в конфигурации существует привилегированный модуль выполнения заданий с именем `Задания`.
В этом модуле есть публичная функция `Функция ДобавитьЗадание(Знач ИмяМетода, Знач Параметры) Экспорт`.
Какой-то код конфигурации или расширения обращается к этому методу `Задания.ДобавитьЗадание("МетодДляВыполнения", Параметры);`

Необходимо проанализировать код и убедиться в том, что:
- указан правильный метод для выполнения задания - `МетодДляВыполнения`
- метод `МетодДляВыполнения` для выполнения задания не выполняет деструктивных действий
- и не выдает пользователям данные, запрещенные ограничениями конфигурации

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:PrivilegedModuleMethodCall-off
// BSLLS:PrivilegedModuleMethodCall-on
```

### Параметр конфигурационного файла

```json
"PrivilegedModuleMethodCall": {
    "validateNestedCalls": true
}
```
