# Обращение к несуществующим метаданным в запросе (QueryToMissingMetadata)

|   Тип    |    Поддерживаются<br>языки    |   Важность    |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |            Теги             |
|:--------:|:-----------------------------:|:-------------:|:------------------------------:|:-----------------------------------:|:---------------------------:|
| `Ошибка` |             `BSL`             | `Блокирующий` |              `Да`              |                 `5`                 |    `suspicious`<br>`sql`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

При активной разработке и изменении модели метаданных могут появляться запросы, в которых идет обращение к переименованным или удаленным метаданным.
Также ошибочные имена таблиц могут возникать при ручном изменении запросов, без проверки с помощью конструктора запросов.

При выполнении запросов к несуществующим метаданным будет возникать ошибка исполнения.

## Примеры

Запрос к уже удаленному регистру:
```sdbl
ВЫБРАТЬ
	Таблица.РесурсЧисло КАК РесурсЧисло
ИЗ
	РегистрСведений.УстаревшееИмяРегистра КАК Таблица
```
Запрос с соединением к переименованному регистру:
```sdbl
ВЫБРАТЬ
	Таблица.РесурсЧисло КАК РесурсЧисло
ИЗ
	РегистрСведений.Регистр1 КАК Таблица
	ВНУТРЕННЕЕ СОЕДИНЕНИЕ РегистрСведений.УстаревшееИмяРегистра КАК ТаблицаФильтр
	ПО ТаблицаФильтр.Регистратор = Таблица.Регистратор
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
- [Работа с запросами - стандарты разработки 1С](https://its.1c.ru/db/v8std#browse:13:-1:26:27)
- [Оптимизация запросов - стандарты разработки 1С](https://its.1c.ru/db/v8std#browse:13:-1:26:28)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:QueryToMissingMetadata-off
// BSLLS:QueryToMissingMetadata-on
```

### Параметр конфигурационного файла

```json
"QueryToMissingMetadata": false
```
