# Серверный экспортный метод формы (ServerSideExportFormMethod)

|   Тип    |    Поддерживаются<br>языки    |   Важность    |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                          Теги                          |
|:--------:|:-----------------------------:|:-------------:|:------------------------------:|:-----------------------------------:|:------------------------------------------------------:|
| `Ошибка` |             `BSL`             | `Блокирующий` |              `Да`              |                 `5`                 |       `error`<br>`unpredictable`<br>`suspicious`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

В модуле формы можно объявлять экспортные методы, доступные в клиентском контексте (обычно это методы-обработчики событий оповещения формы).
У экспортных методов формы может быть указана только директива компиляции `НаКлиенте`, так как для остальных практического смысла нет: обращение к методам формы извне доступно только после вызова метода `ПолучитьФорму`, который доступен только на клиенте.

Указание экспортному методу формы иной директивы компиляции либо ее опускание считается ошибкой.

*В некоторых версиях платформы 1С:Предприятие существовала ошибка, позволяющая использовать экспортные серверные методы форм, но проектировать прикладное решение с эксплуатированием ошибок платформы недопустимо.*

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неправильное применение экспортных методов в форме 

```bsl
Процедура БезДирективКомпиляции() Экспорт
  // процедура доступна на сервере
КонецПроцедуры

&НаСервереБезКонтекста
Процедура НаСервереБезКонтекста() Экспорт
КонецПроцедуры

&НаСервере
Процедура НаСервере() Экспорт
КонецПроцедуры
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* [Разработка интерфейса прикладных решений на платформе "1С:Предприятие". Глава 3.5. Исполнение модуля формы на клиенте и на сервере](https://its.1c.ru/db/pubv8devui/content/191/hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:ServerSideExportFormMethod-off
// BSLLS:ServerSideExportFormMethod-on
```

### Параметр конфигурационного файла

```json
"ServerSideExportFormMethod": false
```
