# Приведение к числу в попытке (TryNumber)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `2`                 | `standard` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Неправильно использовать исключения для приведения значения к типу. Для таких операций необходимо использовать возможности объекта ОписаниеТипов.

## Примеры

Неправильно:

```bsl
Попытка
 КоличествоДнейРазрешения = Число(Значение);
Исключение
 КоличествоДнейРазрешения = 0; // значение по умолчанию
КонецПопытки;
```

Правильно:

```bsl
ОписаниеТипа = Новый ОписаниеТипов("Число");
КоличествоДнейРазрешения = ОписаниеТипа.ПривестиЗначение(Значение);
```

## Источники

* [Стандарт: Перехват исключений в коде](https://its.1c.ru/db/v8std#content:499:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:TryNumber-off
// BSLLS:TryNumber-on
```

### Параметр конфигурационного файла

```json
"TryNumber": false
```
