# Неверное использование метода "ЗаписьЖурналаРегистрации" (UsageWriteLogEvent)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Информационный` |              `Да`              |                 `1`                 |    `standard`<br>`badpractice`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
Важно правильно с определенной дотошностью указывать основные параметры при записи в Журнал регистрации.

Недопустимо прятать исключения.
При обработке исключений обязательно нужно выполнять запись в журнал регистрации с полным представлением ошибки.
Для этого нужно добавить в комментарий события результат `ПодробноеПредставлениеОшибки(ИнформацияОбОшибке())`

Нельзя пропускать 2й параметр Уровень журнала регистрации. Если его не указать, по умолчанию 1С применит уровень ошибки Информация, и данная запись может потеряться в потоке записей.

Нельзя пропускать и 5й параметр - комментарий к событию записи в журнал регистрации.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Примеры неверного кода
```bsl
    ЗаписьЖурналаРегистрации("Событие");// ошибка
    ЗаписьЖурналаРегистрации("Событие", УровеньЖурналаРегистрации.Ошибка);// ошибка
    ЗаписьЖурналаРегистрации("Событие", УровеньЖурналаРегистрации.Ошибка, , );// ошибка
    ЗаписьЖурналаРегистрации("Событие", , , , ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));

    ЗаписьЖурналаРегистрации("Событие", УровеньЖурналаРегистрации.Ошибка, , , );// ошибка

    Попытка
      КодСервер();
    Исключение
      ЗаписьЖурналаРегистрации("Событие", УровеньЖурналаРегистрации.Ошибка, , ,
        ОписаниеОшибки()); // ошибка
      ЗаписьЖурналаРегистрации("Событие", УровеньЖурналаРегистрации.Ошибка, , ,
        "Комментарий 1"); // ошибка
    КонецПопытки;
```

Правильный код
```bsl
    Попытка
      КодСервер();
    Исключение

      ТекстОшибки = ПодробноеПредставлениеОшибки(ИнформацияОбОшибке());
      ЗаписьЖурналаРегистрации(НСтр("ru = 'Выполнение операции'"), УровеньЖурналаРегистрации.Ошибка, , ,
         ТекстОшибки);
    КонецПопытки;

    Попытка
      КодСервер();
    Исключение

      ТекстОшибки = ПодробноеПредставлениеОшибки(ИнформацияОбОшибке());
      ЗаписьЖурналаРегистрации(НСтр("ru = 'Выполнение операции'"), УровеньЖурналаРегистрации.Ошибка, , ,
         ТекстОшибки);

      ВызватьИсключение;
    КонецПопытки;
```
В то же время, если во внешней попытке делается запись в ЖР, то во вложенной делать её повторно уже не нужно:
```bsl
Процедура ЗагрузитьДанные() Экспорт
    Попытка
        ВыполнитьЗаписьДанных();
    Исключение
        ЗаписьЖурналаРегистрации(); // <- исключение подавляется с записью в ЖР
    КонецПопытки;
КонецПроцедуры

Процедура ВыполнитьЗаписьДанных()
    НачатьТранзакцию();
    Попытка
        // ...
        ЗафиксироватьТранзакцию();
    Исключение
        ОтменитьТранзакцию();
        ВызватьИсключение; // <- вложенная попытка, запись в ЖР не требуется
    КонецПопытки;
КонецПроцедуры
```
## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* [Использование Журнала регистрации](https://its.1c.ru/db/v8std#content:498:hdoc)
* [Перехват исключений в коде](https://its.1c.ru/db/v8std#content:499:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsageWriteLogEvent-off
// BSLLS:UsageWriteLogEvent-on
```

### Параметр конфигурационного файла

```json
"UsageWriteLogEvent": false
```
