# Оператор "Перейти" не должен использоваться (UsingGoto)

|      Тип      |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Критичный` |              `Да`              |                 `5`                 |    `standard`<br>`badpractice`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

```goto``` является неструктурированным оператором потока управления. Это делает код менее читаемым и обслуживаемым.  
Вместо этого следует использовать структурированные операторы управления потоком, например
```Если```, ```Пока```, ```Для``` ```Продолжить``` или ```Прервать```.

## Примеры

Плохо:

```bsl
Сч = 0;
~Петля: Сообщить(СтрШаблон("Сч = %1", Сч));
Сч = Сч + 1;

Если Сч < 10 Тогда

    Перейти ~Петля;

КонецЕсли;
```

Хорошо:

```bsl
Для Сч = 0 По 10 Цикл

   Сообщить(СтрШаблон("Сч = %1", Сч))

КонецЦикла;
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->

* [Стандарт: Использование перейти](https://its.1c.ru/db/v8std/content/547/hdoc/_top/)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsingGoto-off
// BSLLS:UsingGoto-on
```

### Параметр конфигурационного файла

```json
"UsingGoto": false
```
