# Использование 'ПОДОБНО' в запросе (UsingLikeInQuery)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |              Теги              |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------------------------:|
| `Ошибка` |             `BSL`             | `Важный` |             `Нет`              |                `10`                 |    `sql`<br>`unpredictable`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

В большинстве алгоритмов возможно обойтись без использования оператора `ПОДОБНО`, а в оставшихся необходимо внимательно его использовать, т.к. результат в некоторых ситуациях может сильно отличаться от ожидаемого, например при использовании разных СУБД.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

### Правильно

```bsl
Реквизит ПОДОБНО "123%"
```

### Неправильно:

```bsl
Реквизит ПОДОБНО Таблица.Шаблон
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

- [Стандарт. Особенности использования в запросах оператора ПОДОБНО](https://its.1c.ru/db/v8std#content:726:hdoc)
- [Руководство разработчика. Оператор проверки строки на подобие шаблону](https://its.1c.ru/db/v8318doc#bookmark:dev:TI000000506)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsingLikeInQuery-off
// BSLLS:UsingLikeInQuery-on
```

### Параметр конфигурационного файла

```json
"UsingLikeInQuery": false
```
