/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser.testing;

import com.github._1c_syntax.bsl.parser.testing.TestLexer;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.Token;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class LexerAsserts {
    private final TestLexer<?> lexer;
    private final int channel;
    private final List<Token> tokens;
    private final int mode;

    public LexerAsserts(TestLexer<?> lexer, String inputString, int mode, int channel) {
        this.lexer = lexer;
        this.channel = channel;
        this.mode = mode;
        this.tokens = lexer.getTokens(mode, inputString);
    }

    public LexerAsserts containsExactly(Integer ... expectedTokens) {
        Integer[] tokenTypes = (Integer[])this.tokens.stream().map(Token::getType).toArray(Integer[]::new);
        return this.isEqualTo(expectedTokens, tokenTypes);
    }

    public LexerAsserts containsAll(Integer ... expectedTokens) {
        Integer[] tokenTypes = (Integer[])this.tokens.stream().filter(token -> token.getChannel() == this.channel).map(Token::getType).filter(type -> type != -1).toArray(Integer[]::new);
        return this.isEqualTo(expectedTokens, tokenTypes);
    }

    public LexerAsserts tokenHasText(int index, String text) {
        Token token = this.tokens.get(index);
        Assertions.assertThat((Object)token).isNotNull();
        Assertions.assertThat((String)token.getText()).isEqualTo(text);
        return this;
    }

    public LexerAsserts tokenOnLine(int index, int lineNo) {
        Token token = this.tokens.get(index);
        Assertions.assertThat((Object)token).isNotNull();
        Assertions.assertThat((int)token.getLine()).isEqualTo(lineNo);
        return this;
    }

    public LexerAsserts isEqualTo(String actual) {
        List<Token> actualTokens = this.lexer.getTokens(this.mode, actual);
        return this.isEqualTo(actualTokens);
    }

    private LexerAsserts isEqualTo(List<Token> actual) {
        return this.isEqualTo((Integer[])this.tokens.stream().filter(token -> token.getChannel() == this.channel).map(Token::getType).filter(type -> type != -1).toArray(Integer[]::new), (Integer[])actual.stream().filter(token -> token.getChannel() == this.channel).map(Token::getType).filter(type -> type != -1).toArray(Integer[]::new));
    }

    private LexerAsserts isEqualTo(Integer[] expected, Integer[] actual) {
        if (expected != actual) {
            if (expected.length != actual.length) {
                String expectedDescription = this.lexer.tokenName(expected);
                String actualDescription = this.lexer.tokenName(actual);
                Assertions.assertThat((String)expectedDescription).isEqualTo(actualDescription);
            }
            for (int i = 0; i < expected.length; ++i) {
                Integer expectedElement = expected[i];
                Integer actualElement = actual[i];
                if (Objects.equals(expectedElement, actualElement)) continue;
                ((AbstractStringAssert)Assertions.assertThat((String)this.lexer.tokenName(expectedElement)).describedAs("position " + i, new Object[0])).isEqualTo(this.lexer.tokenName(actualElement));
            }
        }
        return this;
    }
}

