/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser.testing;

import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.parser.testing.TestParser;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Trees;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;

public class ParserAsserts {
    private final Parser parser;
    private final TestParser<?, ?> testParser;
    private final BSLParserRuleContext currentAST;

    public ParserAsserts(TestParser<?, ?> testParser, Parser parser) {
        this.testParser = testParser;
        this.parser = parser;
        Method[] fields = testParser.getParserClazz().getDeclaredMethods();
        Optional<Method> result = Arrays.stream(fields).filter(field -> testParser.ruleName(0).equals(field.getName())).findFirst();
        if (result.isPresent()) {
            this.currentAST = (BSLParserRuleContext)result.get().invoke((Object)parser, new Object[0]);
            this.parser.reset();
        } else {
            this.currentAST = null;
        }
    }

    public ParserAsserts matches(ParseTree tree) throws RecognitionException {
        if (this.parser.getNumberOfSyntaxErrors() != 0) {
            throw new RecognitionException("Syntax error while parsing:\n" + this.parser.getInputStream().getText(), (Recognizer)this.parser, (IntStream)this.parser.getInputStream(), this.parser.getContext());
        }
        if (tree instanceof ParserRuleContext) {
            boolean parseSuccess;
            ParserRuleContext ctx = (ParserRuleContext)tree;
            if (ctx.exception != null) {
                throw ctx.exception;
            }
            if (((ParserRuleContext)tree).parent == null && !(parseSuccess = ((Lexer)this.testParser.getLexerClazz().cast((Object)this.parser.getInputStream().getTokenSource()))._hitEOF)) {
                throw new RecognitionException("Parse error EOF don't hit\n" + this.parser.getInputStream().getText(), (Recognizer)this.parser, (IntStream)this.parser.getInputStream(), this.parser.getContext());
            }
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            this.matches(tree.getChild(i));
        }
        return this;
    }

    public ParserAsserts noMatches(ParseTree tree) {
        Assertions.assertThat((Object)tree).satisfiesAnyOf(new ThrowingConsumer[]{elem -> Assertions.assertThat((int)elem.getChildCount()).isEqualTo(0), elem -> org.junit.jupiter.api.Assertions.assertThrows(RecognitionException.class, () -> this.matches(tree))});
        return this;
    }

    public ParserAsserts containsRule(int ruleId, int count) {
        Assertions.assertThat((Object)this.currentAST).isNotNull();
        List<String> ruleNodes = Trees.findAllRuleNodes((ParseTree)this.currentAST, (int)ruleId).stream().map(ParseTree::getText).toList();
        ((ListAssert)((ListAssert)Assertions.assertThat(ruleNodes).as(this.testParser.ruleName(ruleId) + " (" + ruleId + ")", new Object[0])).isNotNull()).hasSize(count);
        return this;
    }
}

