/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser.testing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;

public final class ResourceUtils {
    public static String byName(@NonNull String resourceName) {
        String content;
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        if (resourceName.isBlank()) {
            throw new IllegalArgumentException("Resource name is blank");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(resourceName);){
            assert (inputStream != null);
            content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Read error: ", e);
        }
        return content;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

