/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser.testing;

import com.github._1c_syntax.bsl.parser.CaseChangingCharStream;
import com.github._1c_syntax.bsl.parser.UnicodeBOMInputStream;
import com.github._1c_syntax.bsl.parser.testing.LexerAsserts;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.UnicodeCharStream;
import org.apache.commons.io.IOUtils;

public class TestLexer<T extends Lexer> {
    private final List<String> ruleNames;
    private final Lexer lexer;

    public TestLexer(Class<T> clazz) {
        this.lexer = this.createLexer(clazz);
        Method[] methods = clazz.getDeclaredMethods();
        Optional<Method> result = Arrays.stream(methods).filter(method -> "getTokenNames".equals(method.getName())).findFirst();
        this.ruleNames = result.isPresent() ? Arrays.asList((String[])result.get().invoke((Object)this.lexer, new Object[0])) : Collections.emptyList();
    }

    public List<Token> getTokens(int mode, String inputString) {
        return this.getTokensStream(mode, inputString).getTokens();
    }

    public CommonTokenStream getTokensStream(int mode, String inputString) {
        CaseChangingCharStream input;
        try (InputStream inputStream = IOUtils.toInputStream((String)inputString, (Charset)StandardCharsets.UTF_8);
             UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(inputStream);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)ubis, StandardCharsets.UTF_8);){
            ubis.skipBOM();
            CodePointCharStream inputTemp = CharStreams.fromReader((Reader)inputStreamReader);
            input = new CaseChangingCharStream((UnicodeCharStream)inputTemp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lexer.setInputStream((CharStream)input);
        this.lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        this.lexer.pushMode(mode);
        CommonTokenStream tempTokenStream = new CommonTokenStream((TokenSource)this.lexer);
        tempTokenStream.fill();
        return tempTokenStream;
    }

    public String tokenName(Integer[] tokenTypes) {
        return Arrays.stream(tokenTypes).map(this::tokenName).collect(Collectors.joining(", "));
    }

    public String tokenName(Integer type) {
        if (!this.ruleNames.isEmpty() && type < this.ruleNames.size()) {
            return this.ruleNames.get(type);
        }
        return type.toString();
    }

    public LexerAsserts assertThat(String inputString) {
        return new LexerAsserts(this, inputString, 0, 0);
    }

    public LexerAsserts assertThat(int mode, String inputString) {
        return new LexerAsserts(this, inputString, mode, 0);
    }

    public LexerAsserts assertThat(int mode, String inputString, int channel) {
        return new LexerAsserts(this, inputString, mode, channel);
    }

    public LexerAsserts assertThat(String inputString, int channel) {
        return new LexerAsserts(this, inputString, 0, channel);
    }

    private T createLexer(Class<T> lexerClass) {
        try {
            return (T)((Lexer)lexerClass.getDeclaredConstructor(CharStream.class, Boolean.TYPE).newInstance(CharStreams.fromString((String)""), true));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Lexer getLexer() {
        return this.lexer;
    }
}

