/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser.description;

import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionParser;
import com.github._1c_syntax.bsl.parser.BSLMethodDescriptionTokenizer;
import com.github._1c_syntax.bsl.parser.description.SourceDefinedSymbolDescription;
import com.github._1c_syntax.bsl.parser.description.support.DescriptionReader;
import com.github._1c_syntax.bsl.parser.description.support.SimpleRange;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.Token;

public final class VariableDescription
implements SourceDefinedSymbolDescription {
    private final String description;
    private final String deprecationInfo;
    private final boolean deprecated;
    private final String purposeDescription;
    private final String link;
    private final SimpleRange range;
    private final VariableDescription trailingDescription;

    VariableDescription(List<Token> comments) {
        this(comments, null);
    }

    VariableDescription(List<Token> comments, @Nullable Token trailingComment) {
        this.description = comments.stream().map(Token::getText).collect(Collectors.joining("\n"));
        BSLMethodDescriptionTokenizer tokenizer = new BSLMethodDescriptionTokenizer(this.description);
        BSLMethodDescriptionParser.MethodDescriptionContext ast = Objects.requireNonNull((BSLMethodDescriptionParser.MethodDescriptionContext)tokenizer.getAst());
        this.range = SimpleRange.create(comments);
        this.purposeDescription = DescriptionReader.readPurposeDescription(ast);
        this.link = DescriptionReader.readLink(ast);
        this.deprecated = ast.deprecate() != null;
        this.deprecationInfo = DescriptionReader.readDeprecationInfo(ast);
        this.trailingDescription = trailingComment == null ? null : new VariableDescription(List.of(trailingComment));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDeprecationInfo() {
        return this.deprecationInfo;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public String getPurposeDescription() {
        return this.purposeDescription;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public SimpleRange getSimpleRange() {
        return this.range;
    }

    public Optional<VariableDescription> getTrailingDescription() {
        return Optional.ofNullable(this.trailingDescription);
    }
}

