/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.parser.description.support;

import java.util.List;
import org.antlr.v4.runtime.Token;

public final class SimpleRange {
    private final int startLine;
    private final int startCharacter;
    private final int endLine;
    private final int endCharacter;

    public SimpleRange(int startLine, int startCharacter, int endLine, int endCharacter) {
        this.startLine = startLine;
        this.startCharacter = startCharacter;
        this.endLine = endLine;
        this.endCharacter = endCharacter;
    }

    public static boolean containsRange(SimpleRange bigger, SimpleRange smaller) {
        if (bigger.getStartLine() > smaller.getStartLine() || bigger.getEndLine() < smaller.getEndLine()) {
            return false;
        }
        if (bigger.getStartLine() == smaller.getStartLine() && bigger.getStartCharacter() > smaller.getStartCharacter()) {
            return false;
        }
        return bigger.getEndLine() != smaller.getEndLine() || bigger.getEndCharacter() >= smaller.getEndCharacter();
    }

    public static SimpleRange create(Token startToken, Token endToken) {
        int startLine = startToken.getLine() - 1;
        int startChar = startToken.getCharPositionInLine();
        int endLine = endToken.getLine() - 1;
        int endChar = endToken.getType() == -1 ? endToken.getCharPositionInLine() : endToken.getCharPositionInLine() + endToken.getText().length();
        return new SimpleRange(startLine, startChar, endLine, endChar);
    }

    public static SimpleRange create(List<Token> tokens) {
        if (tokens.isEmpty()) {
            return new SimpleRange(0, 0, 0, 0);
        }
        Token firstElement = tokens.get(0);
        Token lastElement = tokens.get(tokens.size() - 1);
        return SimpleRange.create(firstElement, lastElement);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartCharacter() {
        return this.startCharacter;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndCharacter() {
        return this.endCharacter;
    }

    public String toString() {
        return ("SimpleRange(startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + ")").intern();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SimpleRange)) {
            return false;
        }
        SimpleRange otherRange = (SimpleRange)other;
        return this.startLine == otherRange.getStartLine() && this.startCharacter == otherRange.getStartCharacter() && this.endLine == otherRange.getEndLine() && this.endCharacter == otherRange.getEndCharacter();
    }
}

