/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdclasses;

import com.github._1c_syntax.bsl.mdclasses.Configuration;
import com.github._1c_syntax.bsl.mdclasses.ExternalReport;
import com.github._1c_syntax.bsl.mdclasses.ExternalSource;
import com.github._1c_syntax.bsl.mdclasses.MDClass;
import com.github._1c_syntax.bsl.reader.MDOReader;
import com.github._1c_syntax.bsl.types.MDOType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MDClasses {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MDClasses.class);
    private static final Pattern SEARCH_CONFIGURATION = Pattern.compile("Configuration\\.(xml|mdo)$");
    private static final Pattern SEARCH_EX_RES = Pattern.compile("[a-zA-Z\u0430-\u044f\u0410-\u042f0-9_\u0451\u0401]+?(?<!Configuration)\\.(xml|mdo)$");

    public static MDClass createConfiguration() {
        return Configuration.EMPTY;
    }

    public static ExternalSource createExternalReport() {
        return ExternalReport.EMPTY;
    }

    public static MDClass createConfiguration(Path path) {
        return MDClasses.createConfiguration(path, false);
    }

    public static MDClass createConfiguration(Path path, boolean skipSupport) {
        return MDOReader.readConfiguration(path, skipSupport);
    }

    public static MDClass createExternalSource(Path mdoPath) {
        return MDOReader.readExternalSource(mdoPath);
    }

    public static List<MDClass> createConfigurations(Path sourcePath) {
        return MDClasses.createConfigurations(sourcePath, false);
    }

    public static List<MDClass> createConfigurations(Path sourcePath, boolean skipSupport) {
        return MDClasses.findFiles(sourcePath, SEARCH_CONFIGURATION).parallelStream().map(path -> MDClasses.createConfiguration(path, skipSupport)).toList();
    }

    public static List<MDClass> createExternalSources(Path sourcePath) {
        return MDClasses.findFiles(sourcePath, SEARCH_EX_RES).parallelStream().map(MDOReader::readExternalSource).toList();
    }

    public static List<MDClass> create(Path sourcePath) {
        return MDClasses.create(sourcePath, false);
    }

    public static List<MDClass> create(Path sourcePath, boolean skipSupport) {
        ArrayList<MDClass> result = new ArrayList<MDClass>(MDClasses.createConfigurations(sourcePath, skipSupport));
        result.addAll(MDClasses.createExternalSources(sourcePath));
        return result;
    }

    private static List<Path> findFiles(Path sourcePath, Pattern pattern) {
        List<Path> listPath = new ArrayList<Path>();
        Set<String> excludeFolders = MDClasses.mdoTypeGroupNames();
        excludeFolders.add("Ext");
        try (Stream<Path> stream = Files.find(sourcePath, Integer.MAX_VALUE, (path, basicFileAttributes) -> {
            if (!basicFileAttributes.isRegularFile()) {
                return false;
            }
            String parentName = path.getParent().getFileName().toString();
            String parentParentName = "";
            if (path.getParent().getParent() != null) {
                parentParentName = path.getParent().getParent().getFileName().toString();
            }
            if (excludeFolders.contains(parentName) || excludeFolders.contains(parentParentName)) {
                return false;
            }
            String fileName = path.getFileName().toString();
            String ext = FilenameUtils.getExtension((String)fileName);
            if (!"xml".equals(ext) && !"mdo".equals(ext)) {
                return false;
            }
            return pattern.matcher(fileName).matches();
        }, new FileVisitOption[0]);){
            listPath = stream.toList();
        }
        catch (IOException e) {
            LOGGER.error("Error read files", (Throwable)e);
        }
        return listPath;
    }

    private static Set<String> mdoTypeGroupNames() {
        return Arrays.stream(MDOType.values()).filter(type -> type != MDOType.EXTERNAL_REPORT && type != MDOType.EXTERNAL_DATA_PROCESSOR && type != MDOType.UNKNOWN).map(MDOType::getGroupName).collect(Collectors.toSet());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MDClasses() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

