/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader;

import com.github._1c_syntax.bsl.mdclasses.MDClass;
import com.github._1c_syntax.bsl.reader.FakeReader;
import com.github._1c_syntax.bsl.reader.MDReader;
import com.github._1c_syntax.bsl.reader.designer.DesignerReader;
import com.github._1c_syntax.bsl.reader.edt.EDTReader;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MDOType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MDOReader {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MDOReader.class);

    public static MDClass readConfiguration(@NonNull Path rootPath) {
        if (rootPath == null) {
            throw new NullPointerException("rootPath is marked non-null but is null");
        }
        return MDOReader.readConfiguration(rootPath, false);
    }

    public static MDClass readConfiguration(@NonNull Path rootPath, boolean skipSupport) {
        if (rootPath == null) {
            throw new NullPointerException("rootPath is marked non-null but is null");
        }
        return MDOReader.createReader(rootPath, skipSupport, MDOType.CONFIGURATION).readConfiguration();
    }

    public static Object read(@NonNull Path folder, @NonNull String fullName) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (fullName == null) {
            throw new NullPointerException("fullName is marked non-null but is null");
        }
        return MDOReader.read(folder, fullName, false);
    }

    public static Object read(@NonNull Path folder, @NonNull String fullName, boolean skipSupport) {
        if (folder == null) {
            throw new NullPointerException("folder is marked non-null but is null");
        }
        if (fullName == null) {
            throw new NullPointerException("fullName is marked non-null but is null");
        }
        MDReader reader = MDOReader.createReader(folder, skipSupport, MDOType.UNKNOWN);
        if (folder.toFile().isFile()) {
            return reader.read(fullName);
        }
        return reader.read(folder, fullName);
    }

    public static MDClass readExternalSource(@NonNull Path mdoPath) {
        if (mdoPath == null) {
            throw new NullPointerException("mdoPath is marked non-null but is null");
        }
        return MDOReader.createReader(mdoPath, true, MDOType.EXTERNAL_REPORT).readExternalSource();
    }

    private static MDReader createReader(Path rootPath, boolean skipSupport, MDOType mdoType) {
        if (mdoType == MDOType.CONFIGURATION || mdoType == MDOType.UNKNOWN) {
            return MDOReader.createReader(rootPath, skipSupport, MDOReader.getConfigurationSourceByPath(rootPath));
        }
        return MDOReader.createReader(rootPath, skipSupport, MDOReader.getConfigurationSourceByPathSimple(rootPath));
    }

    private static MDReader createReader(Path rootPath, boolean skipSupport, ConfigurationSource configurationSource) {
        if (configurationSource == ConfigurationSource.DESIGNER) {
            return new DesignerReader(rootPath, skipSupport);
        }
        if (configurationSource == ConfigurationSource.EDT) {
            return new EDTReader(rootPath, skipSupport);
        }
        return new FakeReader();
    }

    private static ConfigurationSource getConfigurationSourceByPath(Path rootPath) {
        ConfigurationSource configurationSource = ConfigurationSource.EMPTY;
        if (rootPath != null) {
            String rootPathString = rootPath.toString();
            File rootConfiguration = new File(rootPathString, "Configuration.xml");
            if (rootConfiguration.exists()) {
                configurationSource = ConfigurationSource.DESIGNER;
            } else {
                rootConfiguration = Paths.get(rootPathString, EDTReader.CONFIGURATION_MDO_PATH).toFile();
                if (rootConfiguration.exists()) {
                    configurationSource = ConfigurationSource.EDT;
                }
            }
        }
        return configurationSource;
    }

    private static ConfigurationSource getConfigurationSourceByPathSimple(Path mdoPath) {
        File mdoFile;
        ConfigurationSource configurationSource = ConfigurationSource.EMPTY;
        if (mdoPath != null && (mdoFile = mdoPath.toFile()).exists()) {
            if (FilenameUtils.isExtension((String)mdoPath.toString(), (String)"mdo")) {
                configurationSource = ConfigurationSource.EDT;
            } else if (FilenameUtils.isExtension((String)mdoPath.toString(), (String)"xml")) {
                configurationSource = ConfigurationSource.DESIGNER;
            }
        }
        return configurationSource;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MDOReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

