/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.context;

import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.reader.common.TransformationUtils;
import com.github._1c_syntax.bsl.reader.common.context.AbstractReaderContext;
import com.github._1c_syntax.bsl.supconf.ParseSupportData;
import com.github._1c_syntax.bsl.support.CompatibilityMode;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDCReaderContext
extends AbstractReaderContext {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MDCReaderContext.class);
    private static final String UUID_FIELD_NAME = "uuid";
    private static final String MDO_REFERENCE_FIELD_NAME = "mdoReference";
    private static final String SUPPORT_VALIANT_FIELD_NAME = "SupportVariant";
    private static final String CHILD_FILED_NAME = "child";
    private static final String COMPATIBILITY_MODE_FILED_NAME = "compatibilityMode";
    private static final String CONFIGURATION_SOURCE_MODE_FILED_NAME = "configurationSource";
    private CompatibilityMode compatibilityMode;
    private CompatibilityMode configurationExtensionCompatibilityMode;
    private final List<String> childrenNames;

    public MDCReaderContext(@NonNull Class<?> clazz, @NonNull HierarchicalStreamReader reader) {
        super(reader);
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        this.realClass = clazz;
        this.builder = TransformationUtils.builder(this.realClass);
        String uuid = reader.getAttribute(UUID_FIELD_NAME);
        this.supportVariant = ParseSupportData.getSupportVariantByMDO((String)uuid, (Path)this.currentPath);
        this.mdoType = MDOType.CONFIGURATION;
        super.setValue(UUID_FIELD_NAME, uuid);
        super.setValue(SUPPORT_VALIANT_FIELD_NAME, this.supportVariant);
        this.childrenNames = Collections.synchronizedList(new ArrayList());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setValue(String methodName, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (MDOType.fromValue((String)methodName).isPresent()) {
                this.childrenNames.add(string);
                return;
            }
        }
        super.setValue(methodName, value);
    }

    @Override
    public Object build() {
        this.mdoReference = MdoReference.create((MDOType)this.mdoType, (String)this.name);
        this.setValue(MDO_REFERENCE_FIELD_NAME, this.mdoReference);
        if (this.compatibilityMode == null) {
            this.setValue(COMPATIBILITY_MODE_FILED_NAME, this.configurationExtensionCompatibilityMode);
        }
        this.setValue(CONFIGURATION_SOURCE_MODE_FILED_NAME, this.mdReader.getConfigurationSource());
        this.setValueModules();
        this.setValueChildren();
        return super.build();
    }

    private void setValueChildren() {
        List<MD> children = this.childrenNames.parallelStream().map(fullName -> (MD)this.mdReader.read((String)fullName)).filter(Objects::nonNull).toList();
        children.forEach(child -> {
            String fieldName = child.getMdoType().getName();
            this.setValue(fieldName, child);
            this.setValue(CHILD_FILED_NAME, child);
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MDCReaderContext)) {
            return false;
        }
        MDCReaderContext other = (MDCReaderContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompatibilityMode this$compatibilityMode = this.compatibilityMode;
        CompatibilityMode other$compatibilityMode = other.compatibilityMode;
        if (this$compatibilityMode == null ? other$compatibilityMode != null : !this$compatibilityMode.equals(other$compatibilityMode)) {
            return false;
        }
        CompatibilityMode this$configurationExtensionCompatibilityMode = this.configurationExtensionCompatibilityMode;
        CompatibilityMode other$configurationExtensionCompatibilityMode = other.configurationExtensionCompatibilityMode;
        if (this$configurationExtensionCompatibilityMode == null ? other$configurationExtensionCompatibilityMode != null : !this$configurationExtensionCompatibilityMode.equals(other$configurationExtensionCompatibilityMode)) {
            return false;
        }
        List<String> this$childrenNames = this.childrenNames;
        List<String> other$childrenNames = other.childrenNames;
        return !(this$childrenNames == null ? other$childrenNames != null : !((Object)this$childrenNames).equals(other$childrenNames));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MDCReaderContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CompatibilityMode $compatibilityMode = this.compatibilityMode;
        result = result * 59 + ($compatibilityMode == null ? 43 : $compatibilityMode.hashCode());
        CompatibilityMode $configurationExtensionCompatibilityMode = this.configurationExtensionCompatibilityMode;
        result = result * 59 + ($configurationExtensionCompatibilityMode == null ? 43 : $configurationExtensionCompatibilityMode.hashCode());
        List<String> $childrenNames = this.childrenNames;
        result = result * 59 + ($childrenNames == null ? 43 : ((Object)$childrenNames).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCompatibilityMode(CompatibilityMode compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfigurationExtensionCompatibilityMode(CompatibilityMode configurationExtensionCompatibilityMode) {
        this.configurationExtensionCompatibilityMode = configurationExtensionCompatibilityMode;
    }
}

