/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.context;

import com.github._1c_syntax.bsl.mdo.ChildrenOwner;
import com.github._1c_syntax.bsl.mdo.Form;
import com.github._1c_syntax.bsl.mdo.MDChild;
import com.github._1c_syntax.bsl.mdo.ModuleOwner;
import com.github._1c_syntax.bsl.mdo.Subsystem;
import com.github._1c_syntax.bsl.mdo.support.TemplateType;
import com.github._1c_syntax.bsl.reader.common.TransformationUtils;
import com.github._1c_syntax.bsl.reader.common.context.AbstractReaderContext;
import com.github._1c_syntax.bsl.supconf.ParseSupportData;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDReaderContext
extends AbstractReaderContext {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MDReaderContext.class);
    private static final String MDO_REFERENCE_FIELD_NAME = "mdoReference";
    private static final String OWNER_FIELD_NAME = "owner";
    private static final String PARENT_SUBSYSTEM_FIELD_NAME = "parentSubsystem";
    private static final String UUID_FIELD_NAME = "uuid";
    private static final String SUPPORT_VALIANT_FIELD_NAME = "SupportVariant";
    private static final String DATA_FIELD_NAME = "data";
    private final Map<String, List<MDReaderContext>> childrenContexts;
    private TemplateType templateType;
    private MdoReference owner = MdoReference.EMPTY;

    public MDReaderContext(@NonNull HierarchicalStreamReader reader) {
        super(reader);
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        String realClassName = reader.getNodeName();
        this.realClass = this.mdReader.getXstream().getRealClass(realClassName);
        this.builder = TransformationUtils.builder(this.realClass);
        String uuid = reader.getAttribute(UUID_FIELD_NAME);
        this.supportVariant = ParseSupportData.getSupportVariantByMDO((String)uuid, (Path)this.currentPath);
        this.mdoType = MDOType.fromValue((String)realClassName).orElse(MDOType.UNKNOWN);
        super.setValue(UUID_FIELD_NAME, uuid);
        super.setValue(SUPPORT_VALIANT_FIELD_NAME, this.supportVariant);
        this.childrenContexts = new ConcurrentHashMap<String, List<MDReaderContext>>();
    }

    @Override
    public final void setValue(String methodName, Object value) {
        if (value instanceof MDReaderContext) {
            MDReaderContext child = (MDReaderContext)value;
            this.saveChildName(methodName, child);
        } else {
            super.setValue(methodName, value);
        }
    }

    @Override
    public Object build() {
        this.mdoReference = MdoReference.create((MdoReference)this.owner, (MDOType)this.mdoType, (String)this.name);
        this.setValue(MDO_REFERENCE_FIELD_NAME, this.mdoReference);
        if (MDChild.class.isAssignableFrom(this.realClass)) {
            this.setValue(OWNER_FIELD_NAME, this.owner);
        }
        if (Subsystem.class.isAssignableFrom(this.realClass)) {
            this.setValue(PARENT_SUBSYSTEM_FIELD_NAME, this.owner);
        }
        if (Form.class.isAssignableFrom(this.realClass)) {
            this.setValue(DATA_FIELD_NAME, this.mdReader.readFormData(this.currentPath, this.name, this.mdoType));
        }
        if (ChildrenOwner.class.isAssignableFrom(this.realClass)) {
            this.setValueChildren();
        }
        if (ModuleOwner.class.isAssignableFrom(this.realClass)) {
            this.setValueModules();
        }
        return super.build();
    }

    private void saveChildName(String collectionName, MDReaderContext child) {
        this.childrenContexts.computeIfAbsent(collectionName, k -> Collections.synchronizedList(new ArrayList())).add(child);
    }

    private void setValueChildren() {
        this.childrenContexts.forEach((collectionName, collectionSource) -> {
            if (collectionName.endsWith("s")) {
                List<Object> collection = collectionSource.stream().map(childContext -> {
                    childContext.setOwner(this.mdoReference);
                    return childContext.build();
                }).toList();
                this.setValue((String)collectionName, collection);
            } else {
                collectionSource.stream().filter(Objects::nonNull).filter(childContext -> childContext.name != null).forEach(childContext -> {
                    childContext.setOwner(this.mdoReference);
                    this.setValue((String)collectionName, childContext.build());
                });
            }
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MDReaderContext)) {
            return false;
        }
        MDReaderContext other = (MDReaderContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, List<MDReaderContext>> this$childrenContexts = this.childrenContexts;
        Map<String, List<MDReaderContext>> other$childrenContexts = other.childrenContexts;
        if (this$childrenContexts == null ? other$childrenContexts != null : !((Object)this$childrenContexts).equals(other$childrenContexts)) {
            return false;
        }
        TemplateType this$templateType = this.getTemplateType();
        TemplateType other$templateType = other.getTemplateType();
        if (this$templateType == null ? other$templateType != null : !this$templateType.equals(other$templateType)) {
            return false;
        }
        MdoReference this$owner = this.owner;
        MdoReference other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MDReaderContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, List<MDReaderContext>> $childrenContexts = this.childrenContexts;
        result = result * 59 + ($childrenContexts == null ? 43 : ((Object)$childrenContexts).hashCode());
        TemplateType $templateType = this.getTemplateType();
        result = result * 59 + ($templateType == null ? 43 : $templateType.hashCode());
        MdoReference $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MDReaderContext(childrenContexts=" + this.childrenContexts + ", templateType=" + this.getTemplateType() + ", owner=" + this.owner + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TemplateType getTemplateType() {
        return this.templateType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setOwner(MdoReference owner) {
        this.owner = owner;
    }
}

