/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.storage.DataCompositionSchema;
import com.github._1c_syntax.bsl.mdo.storage.QuerySource;
import com.github._1c_syntax.bsl.mdo.support.DataSetType;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

@CommonConverter
public class DataSetConverter
implements ReadConverter {
    private static final String NAME_NODE_NAME = "name";
    private static final String FIELD_NODE_NAME = "field";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String DATA_SOURCE_NODE_NAME = "dataSource";
    private static final String QUERY_SOURCE_NODE_NAME = "query";
    private static final String ITEM_SOURCE_NODE_NAME = "item";
    private static final String DATA_PATH_NODE_NAME = "dataPath";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DataCompositionSchema.DataSet.DataSetBuilder dataSet = DataCompositionSchema.DataSet.builder();
        dataSet.type(DataSetType.fromValue(reader.getAttribute(TYPE_ATTRIBUTE_NAME)));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (NAME_NODE_NAME.equals(nodeName)) {
                dataSet.name(reader.getValue());
            } else if (DATA_SOURCE_NODE_NAME.equals(nodeName)) {
                dataSet.dataSource(reader.getValue());
            } else if (ITEM_SOURCE_NODE_NAME.equals(nodeName)) {
                dataSet.item(ExtendXStream.readValue(context, DataCompositionSchema.DataSet.class));
            } else if (FIELD_NODE_NAME.equals(nodeName)) {
                dataSet.field(DataSetConverter.readField(reader));
            } else if (QUERY_SOURCE_NODE_NAME.equals(nodeName)) {
                dataSet.querySource(ExtendXStream.readValue(context, QuerySource.class));
            }
            reader.moveUp();
        }
        return dataSet.build();
    }

    private static DataCompositionSchema.DataSetField readField(HierarchicalStreamReader reader) {
        String dataPath = "";
        String field = "";
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String fieldNodeName = reader.getNodeName();
            if (FIELD_NODE_NAME.equals(fieldNodeName)) {
                field = reader.getValue();
            } else if (DATA_PATH_NODE_NAME.equals(fieldNodeName)) {
                dataPath = reader.getValue();
            }
            reader.moveUp();
        }
        return new DataCompositionSchema.DataSetField(dataPath, field);
    }

    public boolean canConvert(Class type) {
        return type == DataCompositionSchema.DataSet.class;
    }
}

