/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.ExchangePlan;
import com.github._1c_syntax.bsl.mdo.support.AutoRecordType;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.ArrayList;

@CommonConverter
public class ExchangePlanAutoRecordConverter
implements ReadConverter {
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (!reader.hasMoreChildren()) {
            return null;
        }
        if (ExtendXStream.getCurrentMDReader(reader).getConfigurationSource() == ConfigurationSource.DESIGNER) {
            ArrayList<ExchangePlan.RecordContent> content = new ArrayList<ExchangePlan.RecordContent>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                content.add(ExchangePlanAutoRecordConverter.exchangePlanAutoRecord(reader, context, "Metadata", "AutoRecord"));
                reader.moveUp();
            }
            return content;
        }
        return ExchangePlanAutoRecordConverter.exchangePlanAutoRecord(reader, context, "mdObject", "autoRecord");
    }

    public boolean canConvert(Class type) {
        return ExchangePlan.RecordContent.class.isAssignableFrom(type);
    }

    private static ExchangePlan.RecordContent exchangePlanAutoRecord(HierarchicalStreamReader reader, UnmarshallingContext context, String mdoNodeName, String autoRecordNodeName) {
        if (!reader.hasMoreChildren()) {
            return null;
        }
        ExchangePlan.RecordContent.RecordContentBuilder builder = ExchangePlan.RecordContent.builder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String node = reader.getNodeName();
            if (mdoNodeName.equals(node)) {
                builder.metadata(MdoReference.create((String)reader.getValue()));
            } else if (autoRecordNodeName.equals(node)) {
                builder.autoRecord(ExtendXStream.readValue(context, AutoRecordType.class));
            }
            reader.moveUp();
        }
        return builder.build();
    }
}

