/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;

public class ProtectedModuleInfo {
    private static final byte[] PROTECTED_FILE_HEADER = new byte[]{-1, -1, -1, 127};
    private boolean isProtected;
    private Path modulePath;

    public ProtectedModuleInfo(Path path, boolean onlyFindBin) {
        this.modulePath = path;
        this.isProtected = false;
        if (!this.modulePath.toFile().exists()) {
            Path prtModulePath = Paths.get(FilenameUtils.removeExtension((String)this.modulePath.toFile().getPath()) + ".bin", new String[0]);
            if (prtModulePath.toFile().exists()) {
                this.isProtected = true;
                this.modulePath = prtModulePath;
            }
        } else if (!onlyFindBin) {
            byte[] bytes = new byte[PROTECTED_FILE_HEADER.length];
            try (FileInputStream fis = new FileInputStream(this.modulePath.toFile());){
                this.isProtected = fis.read(bytes) == PROTECTED_FILE_HEADER.length && Arrays.equals(bytes, PROTECTED_FILE_HEADER);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isProtected() {
        return this.isProtected;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getModulePath() {
        return this.modulePath;
    }
}

