/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.Subsystem;
import com.github._1c_syntax.bsl.reader.MDReader;
import com.github._1c_syntax.bsl.reader.common.context.MDReaderContext;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.bsl.types.MDOType;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;

@CommonConverter
public class SubsystemConverter
implements ReadConverter {
    private static final String START_MDOREF_NAME = MDOType.SUBSYSTEM.getName() + ".";
    private static final int COUNT_PARTS = 2;

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String name = reader.getNodeName();
        Path currentPath = ExtendXStream.getCurrentPath(reader);
        MDReader mdReader = ExtendXStream.getCurrentMDReader(reader);
        if (mdReader.subsystemsNodeName().equals(name) && reader.getAttributeCount() == 0) {
            return ExtendXStream.read(reader, SubsystemConverter.dataPath(mdReader, currentPath), START_MDOREF_NAME + reader.getValue());
        }
        MDReaderContext readerContext = new MDReaderContext(reader);
        readerContext.getMdReader().unmarshal(reader, context, readerContext);
        Path prjPath = mdReader.getRootPath();
        Objects.requireNonNull(prjPath);
        String localRootPath = currentPath.toString().replace(prjPath.toString(), "");
        if (localRootPath.split(MDOType.SUBSYSTEM.getName()).length > 2) {
            return readerContext;
        }
        return readerContext.build();
    }

    public boolean canConvert(Class type) {
        return Subsystem.class.isAssignableFrom(type);
    }

    private static Path dataPath(MDReader mdReader, Path currentPath) {
        return Paths.get(mdReader.mdoTypeFolderPath(currentPath).toString(), FilenameUtils.getBaseName((String)currentPath.toString()), MDOType.SUBSYSTEM.getGroupName());
    }
}

