/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.converter;

import com.github._1c_syntax.bsl.mdo.storage.XdtoPackageData;
import com.github._1c_syntax.bsl.reader.common.converter.CommonConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.utils.StringInterner;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import lombok.NonNull;

@CommonConverter
public class XdtoPackageDataConverter
implements ReadConverter {
    private static final String PROPERTY_NODE_NAME = "property";
    private static final String IMPORT_NODE_NAME = "import";
    private static final String VALUE_TYPE_NODE_NAME = "valueType";
    private static final String OBJECT_TYPE_NODE_NAME = "objectType";
    private static final String TYPE_DEF_NODE_NAME = "typeDef";
    private static final String TARGET_NAMESPACE_ATTRIBUTE_NAME = "targetNamespace";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String NAMESPACE_ATTRIBUTE_NAME = "namespace";
    private static final String BASE_ATTRIBUTE_NAME = "base";
    private static final String VARIETY_ATTRIBUTE_NAME = "variety";
    private static final String ENUMERATION_ATTRIBUTE_NAME = "enumeration";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String FORM_ATTRIBUTE_NAME = "form";
    private static final String LOWER_BOUND_ATTRIBUTE_NAME = "lowerBound";
    private static final String UPPER_BOUND_ATTRIBUTE_NAME = "upperBound";
    private static final String NILLABLE_ATTRIBUTE_NAME = "nillable";
    private static final StringInterner stringInterner = new StringInterner();

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        XdtoPackageData.XdtoPackageDataBuilder builder = XdtoPackageData.builder();
        builder.targetNamespace(reader.getAttribute(TARGET_NAMESPACE_ATTRIBUTE_NAME));
        while (reader.hasMoreChildren()) {
            String node;
            reader.moveDown();
            switch (node = reader.getNodeName()) {
                case "import": {
                    builder.oneImport(reader.getAttribute(NAMESPACE_ATTRIBUTE_NAME));
                    break;
                }
                case "property": {
                    builder.property(XdtoPackageDataConverter.readProperty(reader));
                    break;
                }
                case "valueType": {
                    builder.valueType(XdtoPackageDataConverter.readValueType(reader));
                    break;
                }
                case "objectType": {
                    builder.objectType(XdtoPackageDataConverter.readObjectType(reader));
                    break;
                }
            }
            reader.moveUp();
        }
        return builder.build();
    }

    private static XdtoPackageData.ObjectType readObjectType(HierarchicalStreamReader reader) {
        XdtoPackageData.ObjectType.ObjectTypeBuilder builder = XdtoPackageData.ObjectType.builder().name(stringInterner.intern(reader.getAttribute(NAME_ATTRIBUTE_NAME)));
        builder.base(XdtoPackageDataConverter.getAttribute(reader, BASE_ATTRIBUTE_NAME));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            builder.property(XdtoPackageDataConverter.readProperty(reader));
            reader.moveUp();
        }
        return builder.build();
    }

    private static XdtoPackageData.ValueType readValueType(HierarchicalStreamReader reader) {
        XdtoPackageData.ValueType.ValueTypeBuilder builder = XdtoPackageData.ValueType.builder().name(stringInterner.intern(reader.getAttribute(NAME_ATTRIBUTE_NAME)));
        builder.base(XdtoPackageDataConverter.getAttribute(reader, BASE_ATTRIBUTE_NAME));
        builder.variety(XdtoPackageDataConverter.getAttribute(reader, VARIETY_ATTRIBUTE_NAME));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (ENUMERATION_ATTRIBUTE_NAME.equals(reader.getNodeName())) {
                builder.enumeration(stringInterner.intern(reader.getValue()));
            }
            reader.moveUp();
        }
        return builder.build();
    }

    private static XdtoPackageData.Property readProperty(HierarchicalStreamReader reader) {
        XdtoPackageData.Property.PropertyBuilder builder = XdtoPackageData.Property.builder().name(stringInterner.intern(reader.getAttribute(NAME_ATTRIBUTE_NAME)));
        builder.type(XdtoPackageDataConverter.getAttribute(reader, TYPE_ATTRIBUTE_NAME));
        builder.form(XdtoPackageDataConverter.getAttribute(reader, FORM_ATTRIBUTE_NAME));
        String value = reader.getAttribute(LOWER_BOUND_ATTRIBUTE_NAME);
        if (value != null) {
            builder.lowerBound(Integer.parseInt(value));
        }
        if ((value = reader.getAttribute(UPPER_BOUND_ATTRIBUTE_NAME)) != null) {
            builder.upperBound(Integer.parseInt(value));
        }
        if ((value = reader.getAttribute(NILLABLE_ATTRIBUTE_NAME)) != null) {
            builder.nillable(Boolean.parseBoolean(value));
        }
        XdtoPackageDataConverter.readTypeDef(reader, builder);
        return builder.build();
    }

    private static void readTypeDef(HierarchicalStreamReader reader, XdtoPackageData.Property.PropertyBuilder builder) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String node = reader.getNodeName();
            if (!TYPE_DEF_NODE_NAME.equals(node)) {
                reader.moveUp();
                continue;
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                node = reader.getNodeName();
                if (PROPERTY_NODE_NAME.equals(node)) {
                    builder.property(XdtoPackageDataConverter.readProperty(reader));
                }
                reader.moveUp();
            }
            reader.moveUp();
        }
    }

    public boolean canConvert(Class type) {
        return XdtoPackageData.class.isAssignableFrom(type);
    }

    @NonNull
    private static String getAttribute(HierarchicalStreamReader reader, String name) {
        String value = reader.getAttribute(name);
        if (value == null) {
            value = "";
        }
        return stringInterner.intern(value);
    }
}

