/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.common.xstream;

import com.github._1c_syntax.bsl.reader.MDReader;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendReaderWrapper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.AbstractPullReader;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;

public class ExtendStaxDriver
extends StaxDriver {
    private final MDReader mdReader;

    public ExtendStaxDriver(MDReader reader, QNameMap qNameMap) {
        super(qNameMap);
        this.mdReader = reader;
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
    }

    public ExtendStaxDriver(MDReader mdReader) {
        this.mdReader = mdReader;
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
    }

    public HierarchicalStreamReader createReader(File in) {
        try {
            final FileInputStream stream = new FileInputStream(in);
            XMLStreamReader xmlStreamReader = this.createParser(new StreamSource(stream, in.toURI().toASCIIString()));
            AbstractPullReader reader = this.createStaxReader(xmlStreamReader);
            return new ExtendReaderWrapper((HierarchicalStreamReader)reader, in, xmlStreamReader, this.mdReader){

                public void close() {
                    super.close();
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new StreamException((Throwable)e);
        }
    }
}

