/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.designer.converter;

import com.github._1c_syntax.bsl.mdo.storage.form.FormAttribute;
import com.github._1c_syntax.bsl.mdo.storage.form.FormItem;
import com.github._1c_syntax.bsl.reader.common.context.FormElementReaderContext;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerConverter;
import com.github._1c_syntax.bsl.reader.designer.converter.Unmarshaller;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DesignerConverter
public class FormElementConverter
implements ReadConverter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FormElementConverter.class);
    private static final String CONDITIONAL_APPEARANCE_TYPE_NAME = "ConditionalAppearance";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (CONDITIONAL_APPEARANCE_TYPE_NAME.equals(reader.getNodeName())) {
            return null;
        }
        FormElementReaderContext readerContext = new FormElementReaderContext(reader.getNodeName(), reader);
        try {
            readerContext.setValue("id", Integer.parseInt(reader.getAttribute("id")));
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Unknown type {} in file {}", (Object)reader.getNodeName(), (Object)ExtendXStream.getCurrentPath(reader).toString());
            return null;
        }
        readerContext.setValue("type", reader.getNodeName());
        readerContext.setValue("name", reader.getAttribute("name"));
        Unmarshaller.unmarshal(reader, context, readerContext);
        return readerContext.build();
    }

    public boolean canConvert(Class type) {
        return FormItem.class.isAssignableFrom(type) || type == FormAttribute.class;
    }
}

