/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.designer.converter;

import com.github._1c_syntax.bsl.mdo.MDChild;
import com.github._1c_syntax.bsl.mdo.children.ExternalDataSourceTable;
import com.github._1c_syntax.bsl.mdo.children.ObjectForm;
import com.github._1c_syntax.bsl.mdo.children.ObjectTemplate;
import com.github._1c_syntax.bsl.mdo.children.Recalculation;
import com.github._1c_syntax.bsl.reader.common.converter.AbstractReadConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerConverter;
import com.github._1c_syntax.bsl.types.MDOType;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;

@DesignerConverter
public class MDChildConverter
extends AbstractReadConverter {
    private static final Map<String, MDOType> TYPES_BY_CLASSES = MDChildConverter.computeTypes();

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Path currentPath = ExtendXStream.getCurrentPath(reader);
        String realClassName = reader.getNodeName();
        Class<?> realClass = ExtendXStream.getRealClass(reader, realClassName);
        if (TYPES_BY_CLASSES.containsKey(realClass.getName()) && reader.getAttributeCount() == 0) {
            MDOType mdoType = TYPES_BY_CLASSES.get(realClass.getName());
            String childName = ExtendXStream.readValue(context, String.class);
            return ExtendXStream.read(reader, MDChildConverter.childDataPath(currentPath, mdoType, childName));
        }
        return super.read(reader, context);
    }

    public boolean canConvert(Class type) {
        return !ObjectTemplate.class.isAssignableFrom(type) && MDChild.class.isAssignableFrom(type);
    }

    private static Map<String, MDOType> computeTypes() {
        ConcurrentHashMap<String, MDOType> types = new ConcurrentHashMap<String, MDOType>();
        types.put(ObjectForm.class.getName(), MDOType.FORM);
        types.put(Recalculation.class.getName(), MDOType.RECALCULATION);
        types.put(ExternalDataSourceTable.class.getName(), MDOType.EXTERNAL_DATA_SOURCE_TABLE);
        return types;
    }

    private static Path childDataPath(Path path, MDOType mdoType, String childName) {
        return Paths.get(path.getParent().toString(), FilenameUtils.getBaseName((String)path.toString()), mdoType.getGroupName(), childName + ".xml");
    }
}

