/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.designer.converter;

import com.github._1c_syntax.bsl.reader.common.xstream.ReadConverter;
import com.github._1c_syntax.bsl.reader.designer.converter.DesignerConverter;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

@DesignerConverter
public class MdoReferenceConverter
implements ReadConverter {
    private static final String ITEM_NODE_NAME = "Item";
    private static final String METADATA_NODE_NAME = "Metadata";
    private static final String USE_NODE_NAME = "Use";
    private static final String PICTURE_NODE_NAME = "Picture";
    private static final String REF_NODE_NAME = "Ref";

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String nodeName = reader.getNodeName();
        String value = "";
        if (ITEM_NODE_NAME.equals(nodeName) && reader.hasMoreChildren()) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String propertyName = reader.getNodeName();
                if (METADATA_NODE_NAME.equals(propertyName)) {
                    value = reader.getValue();
                    reader.moveUp();
                    break;
                }
                reader.moveUp();
            }
        } else if (USE_NODE_NAME.equals(nodeName) && reader.hasMoreChildren()) {
            reader.moveDown();
            value = reader.getValue();
            reader.moveUp();
        } else if (PICTURE_NODE_NAME.equals(nodeName) && reader.hasMoreChildren()) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String propertyName = reader.getNodeName();
                if (REF_NODE_NAME.equals(propertyName)) {
                    value = reader.getValue();
                    reader.moveUp();
                    break;
                }
                reader.moveUp();
            }
        } else {
            value = reader.getValue();
        }
        if (value.isEmpty() || value.contains("-")) {
            return null;
        }
        return MdoReference.create((String)value);
    }

    public boolean canConvert(Class type) {
        return MdoReference.class.isAssignableFrom(type);
    }
}

