/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.edt;

import com.github._1c_syntax.bsl.mdclasses.Configuration;
import com.github._1c_syntax.bsl.mdclasses.ExternalReport;
import com.github._1c_syntax.bsl.mdclasses.ExternalSource;
import com.github._1c_syntax.bsl.mdclasses.MDClass;
import com.github._1c_syntax.bsl.mdo.Language;
import com.github._1c_syntax.bsl.mdo.children.AccountingFlag;
import com.github._1c_syntax.bsl.mdo.children.Dimension;
import com.github._1c_syntax.bsl.mdo.children.DocumentJournalColumn;
import com.github._1c_syntax.bsl.mdo.children.EnumValue;
import com.github._1c_syntax.bsl.mdo.children.ExtDimensionAccountingFlag;
import com.github._1c_syntax.bsl.mdo.children.ExternalDataSourceTable;
import com.github._1c_syntax.bsl.mdo.children.ExternalDataSourceTableField;
import com.github._1c_syntax.bsl.mdo.children.HTTPServiceMethod;
import com.github._1c_syntax.bsl.mdo.children.HTTPServiceURLTemplate;
import com.github._1c_syntax.bsl.mdo.children.IntegrationServiceChannel;
import com.github._1c_syntax.bsl.mdo.children.ObjectAttribute;
import com.github._1c_syntax.bsl.mdo.children.ObjectCommand;
import com.github._1c_syntax.bsl.mdo.children.ObjectForm;
import com.github._1c_syntax.bsl.mdo.children.ObjectTabularSection;
import com.github._1c_syntax.bsl.mdo.children.ObjectTemplate;
import com.github._1c_syntax.bsl.mdo.children.Recalculation;
import com.github._1c_syntax.bsl.mdo.children.Resource;
import com.github._1c_syntax.bsl.mdo.children.TaskAddressingAttribute;
import com.github._1c_syntax.bsl.mdo.children.WebServiceOperation;
import com.github._1c_syntax.bsl.mdo.children.WebServiceOperationParameter;
import com.github._1c_syntax.bsl.mdo.storage.EmptyFormData;
import com.github._1c_syntax.bsl.mdo.storage.FormData;
import com.github._1c_syntax.bsl.mdo.storage.ManagedFormData;
import com.github._1c_syntax.bsl.reader.MDReader;
import com.github._1c_syntax.bsl.reader.common.context.AbstractReaderContext;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.edt.converter.EDTConverter;
import com.github._1c_syntax.bsl.reader.edt.converter.Unmarshaller;
import com.github._1c_syntax.bsl.supconf.ParseSupportData;
import com.github._1c_syntax.bsl.types.ConfigurationSource;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.ModuleType;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EDTReader
implements MDReader {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(EDTReader.class);
    public static final String CONFIGURATION_MDO_PATH = Paths.get("src", "Configuration", "Configuration.mdo").toString();
    private final ExtendXStream xstream = this.createXMLMapper();
    private final Path rootPath;

    public EDTReader(Path path, boolean skipSupport) {
        this.rootPath = path;
        if (!skipSupport) {
            ParseSupportData.readSimple((Path)this.parentConfigurationsPath());
        }
    }

    @Override
    @NonNull
    public ConfigurationSource getConfigurationSource() {
        return ConfigurationSource.EDT;
    }

    @Override
    @NonNull
    public MDClass readConfiguration() {
        Optional<MDClass> mdc = Optional.ofNullable((MDClass)this.read(EDTReader.mdoPath(this.rootPath, MDOType.CONFIGURATION, MDOType.CONFIGURATION.getName())));
        return mdc.orElse(Configuration.EMPTY);
    }

    @Override
    @NonNull
    public ExternalSource readExternalSource() {
        Object value = this.read(this.rootPath);
        if (value instanceof ExternalSource) {
            ExternalSource externalSource = (ExternalSource)value;
            return externalSource;
        }
        return ExternalReport.EMPTY;
    }

    @Override
    @Nullable
    public Object read(Path folder, String fullName) {
        int dotPosition = fullName.indexOf(46);
        Optional type = MDOType.fromValue((String)fullName.substring(0, dotPosition));
        String name = fullName.substring(dotPosition + 1);
        if (type.isPresent()) {
            Path path = this.rootPath.equals(folder) ? EDTReader.mdoPath(folder, (MDOType)type.get(), name) : EDTReader.mdoPath(folder, name);
            return this.read(path);
        }
        return null;
    }

    @Override
    @Nullable
    public FormData readFormData(Path currentPath, String name, MDOType mdoType) {
        String basePath = currentPath.getParent().toString();
        Path formDataPath = mdoType == MDOType.COMMON_FORM ? Path.of(basePath, "Form.form") : Path.of(basePath, MDOType.FORM.getGroupName(), name, "Form.form");
        if (!formDataPath.toFile().exists()) {
            return EmptyFormData.getEmpty();
        }
        return (FormData)this.read(formDataPath);
    }

    @Override
    @NonNull
    public Path moduleFolder(Path mdoPath, MDOType mdoType) {
        if (mdoType == MDOType.EXTERNAL_DATA_SOURCE_TABLE) {
            return mdoPath.getParent().getParent();
        }
        if (!MDOType.valuesWithoutChildren().contains(mdoType)) {
            return Paths.get(mdoPath.getParent().toString(), mdoType.getGroupName());
        }
        return this.mdoTypeFolderPath(mdoPath);
    }

    @Override
    @NonNull
    public Path modulePath(Path folder, String name, ModuleType moduleType) {
        if (ModuleType.byMDOType((MDOType)MDOType.CONFIGURATION).contains(moduleType)) {
            return Paths.get(folder.toString(), MDOType.CONFIGURATION.getName(), moduleType.getFileName());
        }
        return Paths.get(folder.toString(), name, moduleType.getFileName());
    }

    @Override
    @NonNull
    public Path mdoTypeFolderPath(Path mdoPath) {
        return Paths.get(FilenameUtils.getFullPathNoEndSeparator((String)FilenameUtils.getFullPathNoEndSeparator((String)mdoPath.toString())), new String[0]);
    }

    @Override
    @NonNull
    public String subsystemsNodeName() {
        return "subsystems";
    }

    @Override
    @NonNull
    public String configurationExtensionFilter() {
        return "(<objectBelonging>)";
    }

    @Override
    public void unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context, AbstractReaderContext readerContext) {
        Unmarshaller.unmarshal(reader, context, readerContext);
    }

    private ExtendXStream createXMLMapper() {
        ClassLoaderReference classLoaderReference = new ClassLoaderReference((ClassLoader)new CompositeClassLoader());
        Mapper mapper = ExtendXStream.buildMapper(classLoaderReference);
        ExtendXStream xStream = new ExtendXStream(this, classLoaderReference, mapper);
        EDTReader.registerClasses(xStream);
        ExtendXStream.registerConverters(xStream, "com.github._1c_syntax.bsl.reader.edt.converter", EDTConverter.class);
        return xStream;
    }

    private static void registerClasses(XStream xStream) {
        xStream.alias("accountingFlags", AccountingFlag.class);
        xStream.alias("addressingAttributes", TaskAddressingAttribute.class);
        xStream.alias("attributes", ObjectAttribute.class);
        xStream.alias("columns", DocumentJournalColumn.class);
        xStream.alias("commands", ObjectCommand.class);
        xStream.alias("dimensions", Dimension.class);
        xStream.alias("enumValues", EnumValue.class);
        xStream.alias("extDimensionAccountingFlags", ExtDimensionAccountingFlag.class);
        xStream.alias("forms", ObjectForm.class);
        xStream.alias("integrationServiceChannels", IntegrationServiceChannel.class);
        xStream.alias("languages", Language.class);
        xStream.alias("methods", HTTPServiceMethod.class);
        xStream.alias("operations", WebServiceOperation.class);
        xStream.alias("parameters", WebServiceOperationParameter.class);
        xStream.alias("recalculations", Recalculation.class);
        xStream.alias("resources", Resource.class);
        xStream.alias("tables", ExternalDataSourceTable.class);
        xStream.alias("Table", ExternalDataSourceTable.class);
        xStream.alias("tableFields", ExternalDataSourceTableField.class);
        xStream.alias("tabularSections", ObjectTabularSection.class);
        xStream.alias("templates", ObjectTemplate.class);
        xStream.alias("urlTemplates", HTTPServiceURLTemplate.class);
        xStream.alias("Form", ManagedFormData.class);
    }

    private Path parentConfigurationsPath() {
        return Paths.get(this.rootPath.toString(), "src", MDOType.CONFIGURATION.getName(), "ParentConfigurations.bin");
    }

    private static Path mdoPath(Path rootPath, MDOType type, String name) {
        return EDTReader.mdoPath(Paths.get(rootPath.toString(), "src", type.getGroupName()), name);
    }

    private static Path mdoPath(Path folder, String name) {
        return Paths.get(folder.toString(), name, name + ".mdo");
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExtendXStream getXstream() {
        return this.xstream;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getRootPath() {
        return this.rootPath;
    }
}

