/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.edt.converter;

import com.github._1c_syntax.bsl.mdo.children.ExternalDataSourceTable;
import com.github._1c_syntax.bsl.reader.common.converter.AbstractReadConverter;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.reader.edt.converter.EDTConverter;
import com.github._1c_syntax.bsl.types.MDOType;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;

@EDTConverter
public class ExternalDataSourceTableConverter
extends AbstractReadConverter {
    private static final int POSITION_CHILD_NAME = 3;

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (reader.getAttributeCount() == 0) {
            String childName = reader.getValue().split("\\.")[3];
            return ExtendXStream.read(reader, ExternalDataSourceTableConverter.dataPath(ExtendXStream.getCurrentPath(reader), childName));
        }
        return super.read(reader, context);
    }

    public boolean canConvert(Class type) {
        return ExternalDataSourceTable.class.isAssignableFrom(type);
    }

    private static Path dataPath(Path path, String childName) {
        return Paths.get(path.getParent().toString(), MDOType.EXTERNAL_DATA_SOURCE_TABLE.getGroupName(), childName, childName + ".mdo");
    }
}

