/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.reader.edt.converter;

import com.github._1c_syntax.bsl.mdo.Language;
import com.github._1c_syntax.bsl.mdo.children.ExternalDataSourceTableField;
import com.github._1c_syntax.bsl.mdo.support.MultiLanguageString;
import com.github._1c_syntax.bsl.mdo.support.TemplateType;
import com.github._1c_syntax.bsl.reader.common.context.AbstractReaderContext;
import com.github._1c_syntax.bsl.reader.common.context.MDCReaderContext;
import com.github._1c_syntax.bsl.reader.common.context.MDReaderContext;
import com.github._1c_syntax.bsl.reader.common.xstream.ExtendXStream;
import com.github._1c_syntax.bsl.support.CompatibilityMode;
import com.github._1c_syntax.bsl.types.MDOType;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;

public final class Unmarshaller {
    private static final String NAME_NODE = "name";
    private static final String TEMPLATE_TYPE_NODE = "templateType";
    private static final String CP_MODE_NODE = "compatibilityMode";
    private static final String CP_EXT_MODE_NODE = "configurationExtensionCompatibilityMode";
    private static final String LANGUAGE_NODE = "languages";
    private static final String LANGUAGE_METHOD_NAME = "language";
    private static final String TABLE_FIELDS_NODE = "tableFields";
    private static final String CHILD_FILED = "child";
    private static final String TABLE_FIELDS_FIELD = "fields";

    public static void unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context, AbstractReaderContext readerContext) {
        readerContext.setLastValue(null);
        readerContext.setLastName("");
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            Unmarshaller.readNode(reader.getNodeName(), context, readerContext);
            reader.moveUp();
        }
    }

    private static void readNode(String name, UnmarshallingContext context, AbstractReaderContext readerContext) {
        Optional mdoType;
        Class<Object> fieldClass = null;
        if (readerContext instanceof MDCReaderContext && (mdoType = MDOType.fromValue((String)name)).isPresent()) {
            if (LANGUAGE_NODE.equals(name)) {
                fieldClass = Language.class;
                name = LANGUAGE_METHOD_NAME;
            } else {
                fieldClass = String.class;
            }
        }
        if (fieldClass == null) {
            fieldClass = readerContext.fieldType(name);
        }
        if (fieldClass == null && TABLE_FIELDS_NODE.equals(name)) {
            name = TABLE_FIELDS_FIELD;
            fieldClass = ExternalDataSourceTableField.class;
        }
        if (fieldClass == null) {
            return;
        }
        Object value = ExtendXStream.readValue(context, fieldClass);
        if (readerContext instanceof MDReaderContext) {
            MDReaderContext mdReaderContext = (MDReaderContext)readerContext;
            Unmarshaller.saveExtra(mdReaderContext, name, value);
        } else if (readerContext instanceof MDCReaderContext) {
            MDCReaderContext mdcReaderContext = (MDCReaderContext)readerContext;
            Unmarshaller.saveExtra(mdcReaderContext, name, value);
        }
        readerContext.setValue(name, Unmarshaller.transformMultiLanguageString(readerContext, name, value));
    }

    private static Object transformMultiLanguageString(AbstractReaderContext readerContext, String name, Object value) {
        Object object;
        Object newVal = value;
        if (readerContext.getLastName().equals(name) && (object = readerContext.getLastValue()) instanceof MultiLanguageString) {
            MultiLanguageString lastValue = (MultiLanguageString)object;
            if (value instanceof MultiLanguageString) {
                MultiLanguageString newValue = (MultiLanguageString)value;
                newVal = MultiLanguageString.create(lastValue, newValue);
            }
        }
        readerContext.setLastName(name);
        readerContext.setLastValue(newVal);
        return newVal;
    }

    private static void saveExtra(MDReaderContext readerContext, String name, Object value) {
        if (name.equals(NAME_NODE) && value instanceof String) {
            String string = (String)value;
            readerContext.setName(string);
        } else if (name.equals(TEMPLATE_TYPE_NODE) && value instanceof TemplateType) {
            TemplateType templateType = (TemplateType)value;
            readerContext.setTemplateType(templateType);
        }
    }

    private static void saveExtra(MDCReaderContext readerContext, String name, Object value) {
        if (name.equals(NAME_NODE) && value instanceof String) {
            String string = (String)value;
            readerContext.setName(string);
        } else if (name.equals(CP_MODE_NODE) && value instanceof CompatibilityMode) {
            CompatibilityMode compatibilityMode = (CompatibilityMode)value;
            readerContext.setCompatibilityMode(compatibilityMode);
        } else if (name.equals(CP_EXT_MODE_NODE) && value instanceof CompatibilityMode) {
            CompatibilityMode compatibilityMode = (CompatibilityMode)value;
            readerContext.setConfigurationExtensionCompatibilityMode(compatibilityMode);
        } else if (value instanceof Language) {
            readerContext.setValue(CHILD_FILED, value);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Unmarshaller() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

