/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdclasses;

import com.github._1c_syntax.bsl.mdclasses.CFAccess;
import com.github._1c_syntax.bsl.mdclasses.ConfigurationTree;
import com.github._1c_syntax.bsl.mdclasses.MDClass;
import com.github._1c_syntax.bsl.mdo.CommonModule;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.Module;
import com.github._1c_syntax.bsl.mdo.ModuleOwner;
import com.github._1c_syntax.bsl.mdo.Subsystem;
import com.github._1c_syntax.bsl.mdo.support.ApplicationRunMode;
import com.github._1c_syntax.bsl.mdo.support.InterfaceCompatibilityMode;
import com.github._1c_syntax.bsl.mdo.support.ScriptVariant;
import com.github._1c_syntax.bsl.mdo.support.UsePurposes;
import com.github._1c_syntax.bsl.support.CompatibilityMode;
import com.github._1c_syntax.bsl.types.MdoReference;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface CF
extends MDClass,
ConfigurationTree,
CFAccess {
    public MdoReference getDefaultLanguage();

    public ScriptVariant getScriptVariant();

    public InterfaceCompatibilityMode getInterfaceCompatibilityMode();

    public CompatibilityMode getCompatibilityMode();

    public CompatibilityMode getConfigurationExtensionCompatibilityMode();

    public ApplicationRunMode getDefaultRunMode();

    public String getVendor();

    public String getVersion();

    public List<UsePurposes> getUsePurposes();

    public Map<URI, ModuleType> getModulesByType();

    public Map<URI, Module> getModulesByURI();

    public Map<String, CommonModule> getCommonModulesByName();

    public Map<MdoReference, MD> getChildrenByMdoRef();

    default public Map<ModuleType, URI> mdoModuleTypes(MdoReference mdoReference) {
        MD mD;
        Optional<MD> child = this.findChild(mdoReference);
        if (child.isPresent() && (mD = child.get()) instanceof ModuleOwner) {
            ModuleOwner moduleOwner = (ModuleOwner)mD;
            return moduleOwner.getModuleTypes();
        }
        return Collections.emptyMap();
    }

    default public Map<ModuleType, URI> mdoModuleTypes(String mdoRef) {
        return this.mdoModuleTypes(MdoReference.create((String)mdoRef));
    }

    public Map<URI, MD> getModulesByObject();

    default public List<Subsystem> includedSubsystems(MD md, boolean addParentSubsystem) {
        return this.includedSubsystems(md.getMdoReference(), addParentSubsystem);
    }

    default public List<Subsystem> includedSubsystems(MdoReference mdoReference, boolean addParentSubsystem) {
        return this.getSubsystems().parallelStream().flatMap(subsystem -> subsystem.included(mdoReference, addParentSubsystem).stream()).toList();
    }

    @Override
    default public ModuleType getModuleTypeByURI(URI uri) {
        return this.getModulesByType().getOrDefault(uri, ModuleType.UNKNOWN);
    }

    @Override
    default public Optional<Module> getModuleByUri(URI uri) {
        return Optional.ofNullable(this.getModulesByURI().get(uri));
    }

    @Override
    default public Optional<MD> findChild(URI uri) {
        return Optional.ofNullable(this.getModulesByObject().get(uri));
    }

    @Override
    default public Optional<MD> findChild(MdoReference ref) {
        return Optional.ofNullable(this.getChildrenByMdoRef().get(ref));
    }

    @Override
    default public Optional<CommonModule> findCommonModule(String name) {
        return Optional.ofNullable(this.getCommonModulesByName().get(name));
    }
}

