/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdclasses.helpers;

import com.github._1c_syntax.bsl.mdclasses.CF;
import com.github._1c_syntax.bsl.mdclasses.Configuration;
import com.github._1c_syntax.bsl.mdo.AccessRightsOwner;
import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.Role;
import com.github._1c_syntax.bsl.mdo.storage.RoleData;
import com.github._1c_syntax.bsl.mdo.support.RoleRight;
import com.github._1c_syntax.bsl.types.MdoReference;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class Rights {
    private static final Map<String, List<RoleRight>> POSSIBLE_RIGHTS = Rights.computePossibleRights();

    public static boolean rightAccess(CF cf, RoleRight roleRight) {
        return Rights.rightAccess(cf, cf.getMdoReference(), roleRight);
    }

    public static boolean rightAccess(CF cf, RoleRight roleRight, MD md) {
        return Rights.rightAccess(cf, md.getMdoReference(), roleRight);
    }

    public static boolean rightAccess(CF cf, RoleRight roleRight, MdoReference mdoReference) {
        return Rights.rightAccess(cf, mdoReference, roleRight);
    }

    public static List<Role> rolesAccess(CF cf, RoleRight roleRight) {
        return Rights.rolesAccess(cf, cf.getMdoReference(), roleRight);
    }

    public static List<Role> rolesAccess(CF cf, RoleRight roleRight, MD md) {
        return Rights.rolesAccess(cf, md.getMdoReference(), roleRight);
    }

    public static List<Role> rolesAccess(CF cf, RoleRight roleRight, MdoReference mdoReference) {
        return Rights.rolesAccess(cf, mdoReference, roleRight);
    }

    public static List<RoleRight> getPossibleRights(Class<? extends AccessRightsOwner> clazz) {
        return POSSIBLE_RIGHTS.getOrDefault(clazz.getName(), Collections.emptyList());
    }

    public static boolean isValidRight(Class<? extends AccessRightsOwner> clazz, RoleRight roleRight) {
        return Rights.getPossibleRights(clazz).contains(roleRight);
    }

    private static boolean rightAccess(CF cf, MdoReference mdoReference, RoleRight roleRight) {
        if (cf.equals(Configuration.EMPTY)) {
            return false;
        }
        return cf.getRoles().stream().map(Role::getData).filter(roleData -> !roleData.equals(RoleData.EMPTY)).map(RoleData::getObjectRights).flatMap(Collection::stream).filter(objectRight -> objectRight.getName().equals((Object)mdoReference)).map(RoleData.ObjectRight::getRights).flatMap(Collection::stream).anyMatch(right -> roleRight == right.getName() && right.isValue());
    }

    private static List<Role> rolesAccess(CF cf, MdoReference mdoReference, RoleRight roleRight) {
        if (cf.equals(Configuration.EMPTY)) {
            return Collections.emptyList();
        }
        ArrayList roles = new ArrayList();
        cf.getRoles().forEach(role -> {
            boolean hasAcccess = role.getData().getObjectRights().stream().filter(objectRight -> objectRight.getName().equals((Object)mdoReference)).map(RoleData.ObjectRight::getRights).flatMap(Collection::stream).anyMatch(right -> roleRight == right.getName() && right.isValue());
            if (hasAcccess) {
                roles.add(role);
            }
        });
        return Collections.unmodifiableList(roles);
    }

    private static Map<String, List<RoleRight>> computePossibleRights() {
        try (ScanResult scanResult = new ClassGraph().enableClassInfo().acceptPackages(new String[]{"com.github._1c_syntax.bsl"}).scan();){
            ClassInfoList classes = scanResult.getClassesImplementing(AccessRightsOwner.class);
            HashMap rights = new HashMap();
            classes.stream().filter(ci -> !ci.isInterface()).map(ClassInfo::getName).forEach(name -> rights.put(name, Rights.getPossibleRights(name)));
            Map<String, List<RoleRight>> map = Collections.unmodifiableMap(rights);
            return map;
        }
    }

    private static List<RoleRight> getPossibleRights(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return Collections.emptyList();
        }
        Optional<Method> value = Arrays.stream(clazz.getDeclaredMethods()).filter(method -> "possibleRights".equals(method.getName())).findFirst();
        if (value.isPresent()) {
            try {
                Object result = value.get().invoke(clazz, new Object[0]);
                if (result instanceof List) {
                    List rights = (List)result;
                    return rights.stream().filter(RoleRight.class::isInstance).map(RoleRight.class::cast).toList();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private Rights() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

