/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdo;

import com.github._1c_syntax.bsl.mdo.MDObject;
import com.github._1c_syntax.bsl.mdo.support.MultiLanguageString;
import com.github._1c_syntax.bsl.mdo.support.ObjectBelonging;
import com.github._1c_syntax.bsl.mdo.support.ScriptVariant;
import com.github._1c_syntax.bsl.support.SupportVariant;
import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.bsl.types.MdoReference;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;

public final class Language
implements MDObject {
    public static final Language DEFAULT = Language.defaultLanguage();
    public static final Language ENGLISH = Language.newLanguage("English", "en");
    public static final Language RUSSIAN = Language.newLanguage("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "ru");
    private final String uuid;
    private final String name;
    private final MdoReference mdoReference;
    private final ObjectBelonging objectBelonging;
    private final String comment;
    private final MultiLanguageString synonym;
    private final SupportVariant supportVariant;
    private final String languageCode;

    public static Language defaultLanguage(ScriptVariant scriptVariant) {
        if (scriptVariant == ScriptVariant.ENGLISH) {
            return ENGLISH;
        }
        return RUSSIAN;
    }

    public static Language defaultLanguage() {
        return Language.defaultLanguage(ScriptVariant.RUSSIAN);
    }

    private static Language newLanguage(String name, String code) {
        return Language.builder().name(name).uuid("").synonym(MultiLanguageString.create(code, name)).mdoReference(MdoReference.create((MDOType)MDOType.LANGUAGE, (String)(MDOType.LANGUAGE.getGroupName() + "." + name), (String)(MDOType.LANGUAGE.getGroupNameRu() + "." + name))).languageCode(code).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$uuid() {
        return "";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$name() {
        return "";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static MdoReference $default$mdoReference() {
        return MdoReference.EMPTY;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static ObjectBelonging $default$objectBelonging() {
        return ObjectBelonging.OWN;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$comment() {
        return "";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static MultiLanguageString $default$synonym() {
        return MultiLanguageString.EMPTY;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static SupportVariant $default$supportVariant() {
        return SupportVariant.NONE;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static String $default$languageCode() {
        return "";
    }

    @ConstructorProperties(value={"uuid", "name", "mdoReference", "objectBelonging", "comment", "synonym", "supportVariant", "languageCode"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    Language(String uuid, String name, MdoReference mdoReference, ObjectBelonging objectBelonging, String comment, MultiLanguageString synonym, SupportVariant supportVariant, String languageCode) {
        this.uuid = uuid;
        this.name = name;
        this.mdoReference = mdoReference;
        this.objectBelonging = objectBelonging;
        this.comment = comment;
        this.synonym = synonym;
        this.supportVariant = supportVariant;
        this.languageCode = languageCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static LanguageBuilder builder() {
        return new LanguageBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MdoReference getMdoReference() {
        return this.mdoReference;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ObjectBelonging getObjectBelonging() {
        return this.objectBelonging;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getComment() {
        return this.comment;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MultiLanguageString getSynonym() {
        return this.synonym;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SupportVariant getSupportVariant() {
        return this.supportVariant;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLanguageCode() {
        return this.languageCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Language(uuid=" + this.getUuid() + ", name=" + this.getName() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Language)) {
            return false;
        }
        Language other = (Language)o;
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class LanguageBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean uuid$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String uuid$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean name$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean mdoReference$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private MdoReference mdoReference$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean objectBelonging$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ObjectBelonging objectBelonging$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean comment$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String comment$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean synonym$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private MultiLanguageString synonym$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean supportVariant$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SupportVariant supportVariant$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean languageCode$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String languageCode$value;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        LanguageBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LanguageBuilder uuid(String uuid) {
            this.uuid$value = uuid;
            this.uuid$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LanguageBuilder name(String name) {
            this.name$value = name;
            this.name$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LanguageBuilder mdoReference(MdoReference mdoReference) {
            this.mdoReference$value = mdoReference;
            this.mdoReference$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LanguageBuilder objectBelonging(ObjectBelonging objectBelonging) {
            this.objectBelonging$value = objectBelonging;
            this.objectBelonging$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LanguageBuilder comment(String comment) {
            this.comment$value = comment;
            this.comment$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LanguageBuilder synonym(MultiLanguageString synonym) {
            this.synonym$value = synonym;
            this.synonym$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LanguageBuilder supportVariant(SupportVariant supportVariant) {
            this.supportVariant$value = supportVariant;
            this.supportVariant$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LanguageBuilder languageCode(String languageCode) {
            this.languageCode$value = languageCode;
            this.languageCode$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Language build() {
            String uuid$value = this.uuid$value;
            if (!this.uuid$set) {
                uuid$value = Language.$default$uuid();
            }
            String name$value = this.name$value;
            if (!this.name$set) {
                name$value = Language.$default$name();
            }
            MdoReference mdoReference$value = this.mdoReference$value;
            if (!this.mdoReference$set) {
                mdoReference$value = Language.$default$mdoReference();
            }
            ObjectBelonging objectBelonging$value = this.objectBelonging$value;
            if (!this.objectBelonging$set) {
                objectBelonging$value = Language.$default$objectBelonging();
            }
            String comment$value = this.comment$value;
            if (!this.comment$set) {
                comment$value = Language.$default$comment();
            }
            MultiLanguageString synonym$value = this.synonym$value;
            if (!this.synonym$set) {
                synonym$value = Language.$default$synonym();
            }
            SupportVariant supportVariant$value = this.supportVariant$value;
            if (!this.supportVariant$set) {
                supportVariant$value = Language.$default$supportVariant();
            }
            String languageCode$value = this.languageCode$value;
            if (!this.languageCode$set) {
                languageCode$value = Language.$default$languageCode();
            }
            return new Language(uuid$value, name$value, mdoReference$value, objectBelonging$value, comment$value, synonym$value, supportVariant$value, languageCode$value);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Language.LanguageBuilder(uuid$value=" + this.uuid$value + ", name$value=" + this.name$value + ", mdoReference$value=" + String.valueOf(this.mdoReference$value) + ", objectBelonging$value=" + String.valueOf(this.objectBelonging$value) + ", comment$value=" + this.comment$value + ", synonym$value=" + String.valueOf(this.synonym$value) + ", supportVariant$value=" + String.valueOf(this.supportVariant$value) + ", languageCode$value=" + this.languageCode$value + ")";
        }
    }
}

