/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdo;

import com.github._1c_syntax.bsl.mdo.MD;
import com.github._1c_syntax.bsl.mdo.Module;
import com.github._1c_syntax.bsl.types.ModuleType;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ModuleOwner
extends MD {
    public List<Module> getModules();

    default public List<Module> getAllModules() {
        return this.getModules();
    }

    default public Optional<Module> getModuleByUri(URI uri) {
        return this.getAllModules().stream().filter(module -> module.getUri().equals(uri)).findFirst();
    }

    default public ModuleType getModuleTypeByURI(URI uri) {
        return this.getModuleByUri(uri).map(Module::getModuleType).orElse(ModuleType.UNKNOWN);
    }

    default public Map<ModuleType, URI> getModuleTypes() {
        return this.getModules().stream().collect(Collectors.toMap(Module::getModuleType, Module::getUri));
    }
}

