/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdo.storage;

import com.github._1c_syntax.bsl.mdo.storage.QuerySource;
import com.github._1c_syntax.bsl.mdo.storage.TemplateData;
import com.github._1c_syntax.bsl.mdo.support.DataSetType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public final class DataCompositionSchema
implements TemplateData {
    private final List<DataSet> dataSets;
    private final List<DataSet> plainDataSets;
    private final Path dataPath;

    public DataCompositionSchema(@NonNull List<DataSet> dataSetsTree, @NonNull Path path) {
        if (dataSetsTree == null) {
            throw new NullPointerException("dataSetsTree is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.dataSets = dataSetsTree;
        this.plainDataSets = new ArrayList<DataSet>();
        this.fillPlaintDataSetByList(dataSetsTree);
        this.dataPath = path;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private void fillPlaintDataSetByList(List<DataSet> items) {
        items.forEach(dataSet -> {
            this.plainDataSets.add((DataSet)dataSet);
            this.fillPlaintDataSetByList(dataSet.getItems());
        });
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<DataSet> getDataSets() {
        return this.dataSets;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<DataSet> getPlainDataSets() {
        return this.plainDataSets;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataCompositionSchema)) {
            return false;
        }
        DataCompositionSchema other = (DataCompositionSchema)o;
        List<DataSet> this$dataSets = this.getDataSets();
        List<DataSet> other$dataSets = other.getDataSets();
        if (this$dataSets == null ? other$dataSets != null : !((Object)this$dataSets).equals(other$dataSets)) {
            return false;
        }
        List<DataSet> this$plainDataSets = this.getPlainDataSets();
        List<DataSet> other$plainDataSets = other.getPlainDataSets();
        if (this$plainDataSets == null ? other$plainDataSets != null : !((Object)this$plainDataSets).equals(other$plainDataSets)) {
            return false;
        }
        Path this$dataPath = this.getDataPath();
        Path other$dataPath = other.getDataPath();
        return !(this$dataPath == null ? other$dataPath != null : !((Object)this$dataPath).equals(other$dataPath));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DataSet> $dataSets = this.getDataSets();
        result = result * 59 + ($dataSets == null ? 43 : ((Object)$dataSets).hashCode());
        List<DataSet> $plainDataSets = this.getPlainDataSets();
        result = result * 59 + ($plainDataSets == null ? 43 : ((Object)$plainDataSets).hashCode());
        Path $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : ((Object)$dataPath).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DataCompositionSchema(dataSets=" + String.valueOf(this.getDataSets()) + ", plainDataSets=" + String.valueOf(this.getPlainDataSets()) + ", dataPath=" + String.valueOf(this.getDataPath()) + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Path getDataPath() {
        return this.dataPath;
    }

    public static final class DataSet {
        private final String name;
        private final DataSetType type;
        private final String dataSource;
        private final List<DataSet> items;
        private final QuerySource querySource;
        private final List<DataSetField> fields;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private static String $default$name() {
            return "";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private static DataSetType $default$type() {
            return DataSetType.DATA_SET_QUERY;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private static String $default$dataSource() {
            return "";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private static QuerySource $default$querySource() {
            return QuerySource.empty();
        }

        @ConstructorProperties(value={"name", "type", "dataSource", "items", "querySource", "fields"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        DataSet(String name, DataSetType type, String dataSource, List<DataSet> items, QuerySource querySource, List<DataSetField> fields) {
            this.name = name;
            this.type = type;
            this.dataSource = dataSource;
            this.items = items;
            this.querySource = querySource;
            this.fields = fields;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static DataSetBuilder builder() {
            return new DataSetBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DataSetType getType() {
            return this.type;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getDataSource() {
            return this.dataSource;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<DataSet> getItems() {
            return this.items;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public QuerySource getQuerySource() {
            return this.querySource;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<DataSetField> getFields() {
            return this.fields;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DataCompositionSchema.DataSet(name=" + this.getName() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSet)) {
                return false;
            }
            DataSet other = (DataSet)o;
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public static class DataSetBuilder {
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean name$set;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String name$value;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean type$set;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private DataSetType type$value;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean dataSource$set;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private String dataSource$value;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private ArrayList<DataSet> items;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private boolean querySource$set;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private QuerySource querySource$value;
            @SuppressFBWarnings(justification="generated code")
            @Generated
            private ArrayList<DataSetField> fields;

            @SuppressFBWarnings(justification="generated code")
            @Generated
            DataSetBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder name(String name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder type(DataSetType type) {
                this.type$value = type;
                this.type$set = true;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder dataSource(String dataSource) {
                this.dataSource$value = dataSource;
                this.dataSource$set = true;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder item(DataSet item) {
                if (this.items == null) {
                    this.items = new ArrayList();
                }
                this.items.add(item);
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder items(Collection<? extends DataSet> items) {
                if (items == null) {
                    throw new NullPointerException("items cannot be null");
                }
                if (this.items == null) {
                    this.items = new ArrayList();
                }
                this.items.addAll(items);
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder clearItems() {
                if (this.items != null) {
                    this.items.clear();
                }
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder querySource(QuerySource querySource) {
                this.querySource$value = querySource;
                this.querySource$set = true;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder field(DataSetField field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder fields(Collection<? extends DataSetField> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSetBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public DataSet build() {
                List<DataSet> items = switch (this.items == null ? 0 : this.items.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.items.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<DataSet>(this.items));
                };
                List<DataSetField> fields = switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.fields.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<DataSetField>(this.fields));
                };
                String name$value = this.name$value;
                if (!this.name$set) {
                    name$value = DataSet.$default$name();
                }
                DataSetType type$value = this.type$value;
                if (!this.type$set) {
                    type$value = DataSet.$default$type();
                }
                String dataSource$value = this.dataSource$value;
                if (!this.dataSource$set) {
                    dataSource$value = DataSet.$default$dataSource();
                }
                QuerySource querySource$value = this.querySource$value;
                if (!this.querySource$set) {
                    querySource$value = DataSet.$default$querySource();
                }
                return new DataSet(name$value, type$value, dataSource$value, items, querySource$value, fields);
            }

            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String toString() {
                return "DataCompositionSchema.DataSet.DataSetBuilder(name$value=" + this.name$value + ", type$value=" + String.valueOf(this.type$value) + ", dataSource$value=" + this.dataSource$value + ", items=" + String.valueOf(this.items) + ", querySource$value=" + String.valueOf(this.querySource$value) + ", fields=" + String.valueOf(this.fields) + ")";
            }
        }
    }

    public record DataSetField(String dataPath, String name) {
    }
}

