/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdo.storage.form;

import com.github._1c_syntax.bsl.mdo.support.EnumWithValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FormElementType implements EnumWithValue
{
    ADDITION("Addition"),
    ATTRIBUTE("Attribute"),
    BUTTON("Button"),
    BUTTON_GROUP("ButtonGroup"),
    CALENDAR_FIELD("CalendarField"),
    CHART_FIELD("ChartField"),
    CHECK_BOX_FIELD("CheckBoxField"),
    COLUMN_GROUP("ColumnGroup"),
    COMMAND_BAR("CommandBar"),
    COMMAND_BAR_BUTTON("CommandBarButton"),
    COMMAND_BAR_HYPERLINK("CommandBarHyperlink"),
    DECORATION("Decoration"),
    FORMATTED_DOCUMENT_FIELD("FormattedDocumentField"),
    FORM_FIELD("FormField"),
    FORM_GROUP("FormGroup"),
    GANTT_CHART_FIELD("GanttChartField"),
    GRAPHICAL_SCHEMA_FIELD("GraphicalSchemaField"),
    HTML_DOCUMENT_FIELD("HTMLDocumentField"),
    HYPERLINK("Hyperlink"),
    INPUT_FIELD("InputField"),
    LABEL("Label"),
    LABEL_DECORATION("LabelDecoration"),
    LABEL_FIELD("LabelField"),
    PAGE("Page"),
    PAGES("Pages"),
    PDF_DOCUMENT_FIELD("PDFDocumentField"),
    PERIOD_FIELD("PeriodField"),
    PICTURE_DECORATION("PictureDecoration"),
    PICTURE_FIELD("PictureField"),
    PLANNER_FIELD("PlannerField"),
    POPUP("Popup"),
    PROGRESS_BAR_FIELD("ProgressBarField"),
    RADIO_BUTTON_FIELD("RadioButtonField"),
    SEARCH_CONTROL_ADDITION("SearchControlAddition"),
    SEARCH_STRING_ADDITION("SearchStringAddition"),
    SPREADSHEET_DOCUMENT_FIELD("SpreadsheetDocumentField"),
    SPREAD_SHEET_DOCUMENT_FIELD("SpreadSheetDocumentField"),
    TABLE("Table"),
    TEXT_DOCUMENT_FIELD("TextDocumentField"),
    TRACK_BAR_FIELD("TrackBarField"),
    UNKNOWN("unknown"){

        @Override
        public boolean isUnknown() {
            return true;
        }
    }
    ,
    USUAL_BUTTON("UsualButton"),
    USUAL_GROUP("UsualGroup"),
    VIEW_STATUS_ADDITION("ViewStatusAddition");

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER;
    private static final Map<String, FormElementType> KEYS;
    private final String value;

    public static FormElementType fromString(String value) {
        FormElementType result = KEYS.getOrDefault(value, UNKNOWN);
        if (result.isUnknown()) {
            LOGGER.warn("Unknown form element type: {}", (Object)value);
        }
        return KEYS.getOrDefault(value, UNKNOWN);
    }

    private static Map<String, FormElementType> computeKeys() {
        HashMap<String, FormElementType> keys = new HashMap<String, FormElementType>();
        for (FormElementType formElementType : FormElementType.values()) {
            keys.put(formElementType.value, formElementType);
        }
        return Collections.unmodifiableMap(keys);
    }

    @ConstructorProperties(value={"value"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private FormElementType(String value) {
        this.value = value;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String value() {
        return this.value;
    }

    static {
        LOGGER = LoggerFactory.getLogger(FormElementType.class);
        KEYS = FormElementType.computeKeys();
    }
}

