/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.mdo.storage.form;

import com.github._1c_syntax.utils.GenericInterner;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;

public final class FormHandler
implements Comparable<FormHandler> {
    private static final GenericInterner<FormHandler> interner = new GenericInterner();
    private static final StringInterner stringInterner = new StringInterner();
    private final String event;
    private final String name;

    private FormHandler(String event, String name) {
        this.event = stringInterner.intern(event);
        this.name = stringInterner.intern(name);
    }

    public static FormHandler create(String event, String name) {
        return new FormHandler(event, name).intern();
    }

    @Override
    public int compareTo(@Nullable FormHandler formHandler) {
        if (formHandler == null) {
            return 1;
        }
        if (this.equals(formHandler)) {
            return 0;
        }
        int compareResult = this.event.compareTo(formHandler.event);
        if (compareResult == 0) {
            compareResult = this.name.compareTo(formHandler.name);
        }
        return compareResult;
    }

    private FormHandler intern() {
        return (FormHandler)interner.intern((Object)this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String event() {
        return this.event;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String name() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "FormHandler(event=" + this.event() + ", name=" + this.name() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormHandler)) {
            return false;
        }
        FormHandler other = (FormHandler)o;
        String this$event = this.event();
        String other$event = other.event();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

